/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.coordination.stateless.StoreHeartbeatService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.s3.AmazonS3Reference;
import org.elasticsearch.repositories.s3.HttpScheme;
import org.elasticsearch.repositories.s3.RegionFromEndpointGuesser;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3ClientsManager;
import org.elasticsearch.repositories.s3.S3DefaultRegionHolder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.ResolveIdentityRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.retries.StandardRetryStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsWebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.utils.SdkAutoCloseable;

class S3Service
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = LogManager.getLogger(S3Service.class);
    static final Setting<TimeValue> REPOSITORY_S3_CAS_TTL_SETTING = Setting.timeSetting((String)"repository_s3.compare_and_exchange.time_to_live", (Setting)StoreHeartbeatService.HEARTBEAT_FREQUENCY, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> REPOSITORY_S3_CAS_ANTI_CONTENTION_DELAY_SETTING = Setting.timeSetting((String)"repository_s3.compare_and_exchange.anti_contention_delay", (TimeValue)TimeValue.timeValueSeconds((long)1L), (TimeValue)TimeValue.timeValueMillis((long)1L), (TimeValue)TimeValue.timeValueHours((long)24L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final S3DefaultRegionHolder defaultRegionHolder;
    private static final Signer signer = AwsS3V4Signer.create();
    final CustomWebIdentityTokenCredentialsProvider webIdentityTokenCredentialsProvider;
    final TimeValue compareAndExchangeTimeToLive;
    final TimeValue compareAndExchangeAntiContentionDelay;
    final boolean isStateless;
    private final S3ClientsManager s3ClientsManager;

    S3Service(Environment environment, ClusterService clusterService, ProjectResolver projectResolver, ResourceWatcherService resourceWatcherService, Supplier<Region> defaultRegionSupplier) {
        Settings nodeSettings = clusterService.getSettings();
        this.webIdentityTokenCredentialsProvider = new CustomWebIdentityTokenCredentialsProvider(environment, System::getenv, System::getProperty, Clock.systemUTC(), resourceWatcherService);
        this.compareAndExchangeTimeToLive = (TimeValue)REPOSITORY_S3_CAS_TTL_SETTING.get(nodeSettings);
        this.compareAndExchangeAntiContentionDelay = (TimeValue)REPOSITORY_S3_CAS_ANTI_CONTENTION_DELAY_SETTING.get(nodeSettings);
        this.isStateless = DiscoveryNode.isStateless((Settings)nodeSettings);
        this.defaultRegionHolder = new S3DefaultRegionHolder(defaultRegionSupplier);
        this.s3ClientsManager = new S3ClientsManager(nodeSettings, this::buildClientReference, clusterService.threadPool().generic(), projectResolver.supportsMultipleProjects());
        if (projectResolver.supportsMultipleProjects()) {
            clusterService.addHighPriorityApplier((ClusterStateApplier)this.s3ClientsManager);
        }
    }

    S3ClientsManager getS3ClientsManager() {
        return this.s3ClientsManager;
    }

    public synchronized void refreshAndClearCache(Map<String, S3ClientSettings> clientsSettings) {
        this.s3ClientsManager.refreshAndClearCacheForClusterClients(clientsSettings);
    }

    public AmazonS3Reference client(@Nullable ProjectId projectId, RepositoryMetadata repositoryMetadata) {
        return this.s3ClientsManager.client(this.effectiveProjectId(projectId), repositoryMetadata);
    }

    ProjectId effectiveProjectId(@Nullable ProjectId projectId) {
        return projectId == null ? ProjectId.DEFAULT : projectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AmazonS3Reference buildClientReference(S3ClientSettings clientSettings) {
        SdkHttpClient httpClient = this.buildHttpClient(clientSettings, this.getCustomDnsResolver());
        Releasable toRelease = () -> ((SdkHttpClient)httpClient).close();
        try {
            AmazonS3Reference clientReference = new AmazonS3Reference(this.buildClient(clientSettings, httpClient), httpClient);
            clientReference.mustIncRef();
            toRelease = null;
            AmazonS3Reference amazonS3Reference = clientReference;
            return amazonS3Reference;
        }
        finally {
            Releasables.close((Releasable)toRelease);
        }
    }

    S3ClientSettings settings(@Nullable ProjectId projectId, RepositoryMetadata repositoryMetadata) {
        return this.s3ClientsManager.settingsForClient(this.effectiveProjectId(projectId), repositoryMetadata);
    }

    S3Client buildClient(S3ClientSettings clientSettings, SdkHttpClient httpClient) {
        S3ClientBuilder s3clientBuilder = this.buildClientBuilder(clientSettings, httpClient);
        return (S3Client)s3clientBuilder.build();
    }

    protected S3ClientBuilder buildClientBuilder(S3ClientSettings clientSettings, SdkHttpClient httpClient) {
        Region clientRegion;
        S3ClientBuilder s3clientBuilder = S3Client.builder();
        s3clientBuilder.httpClient(httpClient);
        s3clientBuilder.overrideConfiguration(S3Service.buildConfiguration(clientSettings, this.isStateless));
        s3clientBuilder.serviceConfiguration(b -> b.chunkedEncodingEnabled(Boolean.valueOf(!clientSettings.disableChunkedEncoding)));
        s3clientBuilder.credentialsProvider(S3Service.buildCredentials(LOGGER, clientSettings, this.webIdentityTokenCredentialsProvider));
        if (clientSettings.pathStyleAccess) {
            s3clientBuilder.forcePathStyle(Boolean.valueOf(true));
        }
        if ((clientRegion = this.getClientRegion(clientSettings)) == null) {
            s3clientBuilder.region(Region.US_EAST_1);
            s3clientBuilder.crossRegionAccessEnabled(Boolean.valueOf(true));
        } else {
            s3clientBuilder.region(clientRegion);
        }
        if (Strings.hasLength((String)clientSettings.endpoint)) {
            Object endpoint = clientSettings.endpoint;
            if (!(((String)endpoint).startsWith("http://") || ((String)endpoint).startsWith("https://"))) {
                endpoint = switch (clientSettings.protocol) {
                    default -> throw new MatchException(null, null);
                    case HttpScheme.HTTP -> "http://" + (String)endpoint;
                    case HttpScheme.HTTPS -> "https://" + (String)endpoint;
                };
                LOGGER.warn("found S3 client with endpoint [{}] that is missing a scheme, guessing it should be [{}]; to suppress this warning, add a scheme prefix to the [{}] setting on this node", (Object)clientSettings.endpoint, endpoint, (Object)S3ClientSettings.ENDPOINT_SETTING.getConcreteSettingForNamespace("CLIENT_NAME").getKey());
            }
            s3clientBuilder.endpointOverride(URI.create((String)endpoint));
        }
        return s3clientBuilder;
    }

    @Nullable
    Region getClientRegion(S3ClientSettings clientSettings) {
        Object endpointDescription;
        if (Strings.hasLength((String)clientSettings.region)) {
            return Region.of((String)clientSettings.region);
        }
        boolean hasEndpoint = Strings.hasLength((String)clientSettings.endpoint);
        if (hasEndpoint) {
            String guessedRegion = RegionFromEndpointGuesser.guessRegion(clientSettings.endpoint);
            if (guessedRegion != null) {
                LOGGER.warn("found S3 client with endpoint [{}] but no configured region, guessing it should use [{}]; to suppress this warning, configure the [{}] setting on this node", (Object)clientSettings.endpoint, (Object)guessedRegion, (Object)S3ClientSettings.REGION.getConcreteSettingForNamespace("CLIENT_NAME").getKey());
                return Region.of((String)guessedRegion);
            }
            endpointDescription = "configured endpoint [" + clientSettings.endpoint + "]";
        } else {
            endpointDescription = "no configured endpoint";
        }
        Region defaultRegion = this.defaultRegionHolder.getDefaultRegion();
        if (defaultRegion != null) {
            LOGGER.debug("found S3 client with no configured region and {}, using region [{}] from SDK", endpointDescription, (Object)defaultRegion);
            return defaultRegion;
        }
        LOGGER.warn("found S3 client with no configured region and {}, falling back to [{}]{}; to suppress this warning, configure the [{}] setting on this node", endpointDescription, (Object)Region.US_EAST_1, (Object)(hasEndpoint ? "" : " and enabling cross-region access"), (Object)S3ClientSettings.REGION.getConcreteSettingForNamespace("CLIENT_NAME").getKey());
        return hasEndpoint ? Region.US_EAST_1 : null;
    }

    @Nullable
    DnsResolver getCustomDnsResolver() {
        return null;
    }

    Optional<Duration> getConnectionAcquisitionTimeout() {
        return Optional.empty();
    }

    private SdkHttpClient buildHttpClient(S3ClientSettings clientSettings, @Nullable DnsResolver dnsResolver) {
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        Optional<Duration> optConnectionAcquisitionTimout = this.getConnectionAcquisitionTimeout();
        if (optConnectionAcquisitionTimout.isPresent()) {
            httpClientBuilder.connectionAcquisitionTimeout(optConnectionAcquisitionTimout.get());
        }
        httpClientBuilder.maxConnections(Integer.valueOf(clientSettings.maxConnections));
        httpClientBuilder.socketTimeout(Duration.ofMillis(clientSettings.readTimeoutMillis));
        Optional<ProxyConfiguration> proxyConfiguration = S3Service.buildProxyConfiguration(clientSettings);
        if (proxyConfiguration.isPresent()) {
            httpClientBuilder.proxyConfiguration(proxyConfiguration.get());
        }
        if (dnsResolver != null) {
            httpClientBuilder.dnsResolver(dnsResolver);
        }
        return httpClientBuilder.build();
    }

    static boolean isInvalidAccessKeyIdException(Throwable e) {
        if (e instanceof AwsServiceException) {
            AwsServiceException ase = (AwsServiceException)e;
            return ase.statusCode() == RestStatus.FORBIDDEN.getStatus() && "InvalidAccessKeyId".equals(ase.awsErrorDetails().errorCode());
        }
        return false;
    }

    static ClientOverrideConfiguration buildConfiguration(S3ClientSettings clientSettings, boolean isStateless) {
        ClientOverrideConfiguration.Builder clientOverrideConfiguration = ClientOverrideConfiguration.builder();
        clientOverrideConfiguration.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)signer);
        StandardRetryStrategy.Builder retryStrategyBuilder = (StandardRetryStrategy.Builder)AwsRetryStrategy.standardRetryStrategy().toBuilder().maxAttempts(clientSettings.maxRetries + 1);
        if (isStateless) {
            retryStrategyBuilder.retryOnException(S3Service::isInvalidAccessKeyIdException);
        }
        clientOverrideConfiguration.retryStrategy((RetryStrategy)retryStrategyBuilder.build());
        return (ClientOverrideConfiguration)clientOverrideConfiguration.build();
    }

    static Optional<ProxyConfiguration> buildProxyConfiguration(S3ClientSettings clientSettings) {
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            URI proxyUri;
            URIBuilder uriBuilder = new URIBuilder().setScheme(clientSettings.proxyScheme.getSchemeString()).setHost(clientSettings.proxyHost).setPort(clientSettings.proxyPort);
            try {
                proxyUri = uriBuilder.build();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            return Optional.of((ProxyConfiguration)ProxyConfiguration.builder().endpoint(proxyUri).username(clientSettings.proxyUsername).password(clientSettings.proxyPassword).build());
        }
        return Optional.empty();
    }

    static AwsCredentialsProvider buildCredentials(Logger logger, S3ClientSettings clientSettings, CustomWebIdentityTokenCredentialsProvider webIdentityTokenCredentialsProvider) {
        AwsCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            if (webIdentityTokenCredentialsProvider.isActive()) {
                logger.debug("Using a custom provider chain of Web Identity Token and instance profile credentials");
                return AwsCredentialsProviderChain.builder().reuseLastProviderEnabled(Boolean.valueOf(false)).addCredentialsProvider((AwsCredentialsProvider)new ErrorLoggingCredentialsProvider(webIdentityTokenCredentialsProvider, LOGGER)).addCredentialsProvider((AwsCredentialsProvider)new ErrorLoggingCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create(), LOGGER)).build();
            }
            logger.debug("Using DefaultCredentialsProvider for credentials");
            return DefaultCredentialsProvider.create();
        }
        logger.debug("Using basic key/secret credentials");
        return StaticCredentialsProvider.create((AwsCredentials)credentials);
    }

    public void onBlobStoreClose(@Nullable ProjectId projectId) {
        this.s3ClientsManager.releaseCachedClients(this.effectiveProjectId(projectId));
    }

    protected void doStart() {
        this.defaultRegionHolder.start();
    }

    protected void doStop() {
    }

    public void doClose() throws IOException {
        this.s3ClientsManager.close();
        this.webIdentityTokenCredentialsProvider.close();
    }

    static class CustomWebIdentityTokenCredentialsProvider
    implements AwsCredentialsProvider {
        static final String WEB_IDENTITY_TOKEN_FILE_LOCATION = "repository-s3/aws-web-identity-token-file";
        private StsWebIdentityTokenFileCredentialsProvider credentialsProvider;
        private StsClient securityTokenServiceClient;

        CustomWebIdentityTokenCredentialsProvider(Environment environment, SystemEnvironment systemEnvironment, JvmEnvironment jvmEnvironment, Clock clock, ResourceWatcherService resourceWatcherService) {
            String webIdentityTokenFileEnvVar = systemEnvironment.getEnv(SdkSystemSetting.AWS_WEB_IDENTITY_TOKEN_FILE.name());
            if (webIdentityTokenFileEnvVar == null) {
                return;
            }
            Path webIdentityTokenFileLocation = environment.configDir().resolve(WEB_IDENTITY_TOKEN_FILE_LOCATION);
            if (!Files.exists(webIdentityTokenFileLocation, new LinkOption[0])) {
                LOGGER.warn("Cannot use AWS Web Identity Tokens: AWS_WEB_IDENTITY_TOKEN_FILE is defined as [{}] but Elasticsearch requires a symlink to this token file at location [{}] and there is nothing at that location.", (Object)webIdentityTokenFileEnvVar, (Object)webIdentityTokenFileLocation);
                return;
            }
            if (!Files.isReadable(webIdentityTokenFileLocation)) {
                throw new IllegalStateException(Strings.format((String)"Cannot use AWS Web Identity Tokens: AWS_WEB_IDENTITY_TOKEN_FILE is defined as [%s] but Elasticsearch requires a symlink to this token file at location [{}] and this location is not readable.", (Object[])new Object[]{webIdentityTokenFileEnvVar, webIdentityTokenFileLocation}));
            }
            String roleArn = systemEnvironment.getEnv(SdkSystemSetting.AWS_ROLE_ARN.name());
            if (roleArn == null) {
                LOGGER.warn("Cannot use AWS Web Identity Tokens: AWS_WEB_IDENTITY_TOKEN_FILE is defined as [{}] but Elasticsearch requires the AWS_ROLE_ARN environment variable to be set to the ARN of the role and this variable is not set.", (Object)webIdentityTokenFileEnvVar);
                return;
            }
            String roleSessionName = Objects.requireNonNullElseGet(systemEnvironment.getEnv(SdkSystemSetting.AWS_ROLE_SESSION_NAME.name()), () -> "aws-sdk-java-" + clock.millis());
            StsClientBuilder securityTokenServiceClientBuilder = StsClient.builder();
            String endpointOverride = jvmEnvironment.getProperty("org.elasticsearch.repositories.s3.stsEndpointOverride", null);
            if (endpointOverride != null) {
                securityTokenServiceClientBuilder.endpointOverride(URI.create(endpointOverride));
            }
            securityTokenServiceClientBuilder.credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create());
            this.securityTokenServiceClient = (StsClient)securityTokenServiceClientBuilder.build();
            try {
                this.credentialsProvider = StsWebIdentityTokenFileCredentialsProvider.builder().roleArn(roleArn).roleSessionName(roleSessionName).webIdentityTokenFile(webIdentityTokenFileLocation).stsClient(this.securityTokenServiceClient).build();
                this.setupFileWatcherToRefreshCredentials(webIdentityTokenFileLocation, resourceWatcherService);
            }
            catch (Exception e) {
                this.securityTokenServiceClient.close();
                throw e;
            }
        }

        public String toString() {
            return "CustomWebIdentityTokenCredentialsProvider[" + String.valueOf(this.credentialsProvider) + "]";
        }

        private void setupFileWatcherToRefreshCredentials(final Path webIdentityTokenFileSymlink, ResourceWatcherService resourceWatcherService) {
            FileWatcher watcher = new FileWatcher(webIdentityTokenFileSymlink);
            watcher.addListener((Object)new FileChangesListener(){

                public void onFileCreated(Path file) {
                    this.onFileChanged(file);
                }

                public void onFileChanged(Path file) {
                    if (file.equals(webIdentityTokenFileSymlink)) {
                        LOGGER.debug("WS web identity token file [{}] changed, updating credentials", (Object)file);
                        credentialsProvider.resolveCredentials();
                    }
                }
            });
            try {
                resourceWatcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.LOW);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to start watching AWS web identity token file [{}]", (Throwable)e, new Object[]{webIdentityTokenFileSymlink});
            }
        }

        boolean isActive() {
            return this.credentialsProvider != null;
        }

        public void close() throws IOException {
            Releasables.close((Releasable[])new Releasable[]{CustomWebIdentityTokenCredentialsProvider.releasableFromSdkCloseable((SdkAutoCloseable)this.credentialsProvider), CustomWebIdentityTokenCredentialsProvider.releasableFromSdkCloseable((SdkAutoCloseable)this.securityTokenServiceClient)});
        }

        private static Releasable releasableFromSdkCloseable(SdkAutoCloseable sdkAutoCloseable) {
            return sdkAutoCloseable == null ? null : () -> ((SdkAutoCloseable)sdkAutoCloseable).close();
        }

        public AwsCredentials resolveCredentials() {
            Objects.requireNonNull(this.credentialsProvider, "credentialsProvider is not set");
            return this.credentialsProvider.resolveCredentials();
        }

        public Class<AwsCredentialsIdentity> identityType() {
            Objects.requireNonNull(this.credentialsProvider, "credentialsProvider is not set");
            return this.credentialsProvider.identityType();
        }

        public CompletableFuture<AwsCredentialsIdentity> resolveIdentity(ResolveIdentityRequest request) {
            Objects.requireNonNull(this.credentialsProvider, "credentialsProvider is not set");
            return this.credentialsProvider.resolveIdentity(request);
        }

        public CompletableFuture<? extends AwsCredentialsIdentity> resolveIdentity(Consumer<ResolveIdentityRequest.Builder> consumer) {
            Objects.requireNonNull(this.credentialsProvider, "credentialsProvider is not set");
            return this.credentialsProvider.resolveIdentity(consumer);
        }

        public CompletableFuture<? extends AwsCredentialsIdentity> resolveIdentity() {
            Objects.requireNonNull(this.credentialsProvider, "credentialsProvider is not set");
            return this.credentialsProvider.resolveIdentity();
        }
    }

    @FunctionalInterface
    static interface SystemEnvironment {
        public String getEnv(String var1);
    }

    @FunctionalInterface
    static interface JvmEnvironment {
        public String getProperty(String var1, String var2);
    }

    static class ErrorLoggingCredentialsProvider
    implements AwsCredentialsProvider {
        private final AwsCredentialsProvider delegate;
        private final Logger logger;

        ErrorLoggingCredentialsProvider(AwsCredentialsProvider delegate, Logger logger) {
            this.delegate = Objects.requireNonNull(delegate);
            this.logger = Objects.requireNonNull(logger);
        }

        public AwsCredentials resolveCredentials() {
            try {
                return this.delegate.resolveCredentials();
            }
            catch (Exception e) {
                this.logger.error(() -> "Unable to load credentials from " + String.valueOf(this.delegate), (Throwable)e);
                throw e;
            }
        }

        public Class<AwsCredentialsIdentity> identityType() {
            return this.delegate.identityType();
        }

        private <T> T resultHandler(T result, Throwable exception) {
            if (exception != null) {
                this.logger.error(() -> "Unable to resolve identity from " + String.valueOf(this.delegate), exception);
                if (exception instanceof Error) {
                    Error error = (Error)exception;
                    throw error;
                }
                if (exception instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)exception;
                    throw runtimeException;
                }
                throw new RuntimeException(exception);
            }
            return result;
        }

        public CompletableFuture<AwsCredentialsIdentity> resolveIdentity(ResolveIdentityRequest request) {
            return this.delegate.resolveIdentity(request).handle(this::resultHandler);
        }

        public CompletableFuture<? extends AwsCredentialsIdentity> resolveIdentity(Consumer<ResolveIdentityRequest.Builder> consumer) {
            return this.delegate.resolveIdentity(consumer).handle(this::resultHandler);
        }

        public CompletableFuture<? extends AwsCredentialsIdentity> resolveIdentity() {
            return this.delegate.resolveIdentity().handle(this::resultHandler);
        }

        public String toString() {
            return "ErrorLogging[" + String.valueOf(this.delegate) + "]";
        }
    }
}

