/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Binding;
import com.github.mustachejava.Code;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.ValueCode;
import com.github.mustachejava.reflect.GuardedBinding;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.Wrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.script.mustache.MustacheInvalidParameterException;

final class CustomReflectionObjectHandler
extends ReflectionObjectHandler {
    private final boolean detectMissingParams;

    CustomReflectionObjectHandler(boolean detectMissingParams) {
        this.detectMissingParams = detectMissingParams;
    }

    public Object coerce(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return new ArrayMap(object);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return new CollectionMap(collection);
        }
        return super.coerce(object);
    }

    public Binding createBinding(String name, TemplateContext tc, Code code) {
        return this.detectMissingParams ? new DetectMissingParamsGuardedBinding((ObjectHandler)this, name, tc, code) : super.createBinding(name, tc, code);
    }

    protected AccessibleObject findMember(Class sClass, String name) {
        return null;
    }

    public String stringify(Object object) {
        CollectionUtils.ensureNoSelfReferences((Object)object, (String)"CustomReflectionObjectHandler stringify");
        return super.stringify(object);
    }

    static final class ArrayMap
    extends AbstractMap<Object, Object>
    implements Iterable<Object> {
        private final Object array;
        private final int length;

        ArrayMap(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        @Override
        public Object get(Object key) {
            if ("size".equals(key)) {
                return this.size();
            }
            if (key instanceof Number) {
                Number number = (Number)key;
                return number.intValue() >= 0 && number.intValue() < this.length ? Array.get(this.array, number.intValue()) : null;
            }
            try {
                int index = Integer.parseInt(key.toString());
                return index >= 0 && index < this.length ? Array.get(this.array, index) : null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            Map map = Maps.newMapWithExpectedSize((int)this.length);
            for (int i = 0; i < this.length; ++i) {
                map.put(i, Array.get(this.array, i));
            }
            return map.entrySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < length;
                }

                @Override
                public Object next() {
                    return Array.get(array, this.index++);
                }
            };
        }
    }

    static final class CollectionMap
    extends AbstractMap<Object, Object>
    implements Iterable<Object> {
        private final Collection<Object> col;

        CollectionMap(Collection<Object> col) {
            this.col = col;
        }

        @Override
        public Object get(Object key) {
            if ("size".equals(key)) {
                return this.col.size();
            }
            if (key instanceof Number) {
                Number number = (Number)key;
                return number.intValue() >= 0 && number.intValue() < this.col.size() ? Iterables.get(this.col, (int)number.intValue()) : null;
            }
            try {
                int index = Integer.parseInt(key.toString());
                return index >= 0 && index < this.col.size() ? Iterables.get(this.col, (int)index) : null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            Map map = Maps.newMapWithExpectedSize((int)this.col.size());
            int i = 0;
            for (Object item : this.col) {
                map.put(i++, item);
            }
            return map.entrySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return this.col.iterator();
        }
    }

    static class DetectMissingParamsGuardedBinding
    extends GuardedBinding {
        private final Code code;

        DetectMissingParamsGuardedBinding(ObjectHandler oh, String name, TemplateContext tc, Code code) {
            super(oh, name, tc, code);
            this.code = code;
        }

        protected synchronized Wrapper getWrapper(String name, List<Object> scopes) {
            Wrapper wrapper = super.getWrapper(name, scopes);
            if (wrapper instanceof MissingWrapper && this.code instanceof ValueCode) {
                throw new MustacheInvalidParameterException("Parameter [" + name + "] is missing");
            }
            return wrapper;
        }
    }
}

