/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;

public class Configuration
implements Writeable {
    public static final int QUERY_COMPRESS_THRESHOLD_CHARS = ByteSizeUnit.KB.toIntBytes(5L);
    private static final TransportVersion ESQL_SUPPORT_PARTIAL_RESULTS = TransportVersion.fromName((String)"esql_support_partial_results");
    private final String clusterName;
    private final String username;
    private final ZonedDateTime now;
    private final ZoneId zoneId;
    private final QueryPragmas pragmas;
    private final int resultTruncationMaxSize;
    private final int resultTruncationDefaultSize;
    private final Locale locale;
    private final String query;
    private final boolean profile;
    private final boolean allowPartialResults;
    private final Map<String, Map<String, Column>> tables;
    private final long queryStartTimeNanos;

    public Configuration(ZoneId zi, Locale locale, String username, String clusterName, QueryPragmas pragmas, int resultTruncationMaxSize, int resultTruncationDefaultSize, String query, boolean profile, Map<String, Map<String, Column>> tables, long queryStartTimeNanos, boolean allowPartialResults) {
        this.zoneId = zi.normalized();
        this.now = ZonedDateTime.now(Clock.tick(Clock.system(this.zoneId), Duration.ofNanos(1L)));
        this.username = username;
        this.clusterName = clusterName;
        this.locale = locale;
        this.pragmas = pragmas;
        this.resultTruncationMaxSize = resultTruncationMaxSize;
        this.resultTruncationDefaultSize = resultTruncationDefaultSize;
        this.query = query;
        this.profile = profile;
        this.tables = tables;
        assert (tables != null);
        this.queryStartTimeNanos = queryStartTimeNanos;
        this.allowPartialResults = allowPartialResults;
    }

    public Configuration(BlockStreamInput in) throws IOException {
        this.zoneId = in.readZoneId();
        this.now = Instant.ofEpochSecond(in.readVLong(), in.readVInt()).atZone(this.zoneId);
        this.username = in.readOptionalString();
        this.clusterName = in.readOptionalString();
        this.locale = Locale.forLanguageTag(in.readString());
        this.pragmas = new QueryPragmas((StreamInput)in);
        this.resultTruncationMaxSize = in.readVInt();
        this.resultTruncationDefaultSize = in.readVInt();
        this.query = Configuration.readQuery((StreamInput)in);
        this.profile = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0) ? in.readBoolean() : false;
        this.tables = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0) ? in.readImmutableMap(i1 -> i1.readImmutableMap(i2 -> new Column((BlockStreamInput)i2))) : Map.of();
        this.queryStartTimeNanos = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? in.readLong() : -1L;
        this.allowPartialResults = in.getTransportVersion().supports(ESQL_SUPPORT_PARTIAL_RESULTS) ? in.readBoolean() : false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeZoneId(this.zoneId);
        Instant instant = this.now.toInstant();
        out.writeVLong(instant.getEpochSecond());
        out.writeVInt(instant.getNano());
        out.writeOptionalString(this.username);
        out.writeOptionalString(this.clusterName);
        out.writeString(this.locale.toLanguageTag());
        this.pragmas.writeTo(out);
        out.writeVInt(this.resultTruncationMaxSize);
        out.writeVInt(this.resultTruncationDefaultSize);
        Configuration.writeQuery(out, this.query);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            out.writeBoolean(this.profile);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
            out.writeMap(this.tables, (o1, columns) -> o1.writeMap(columns, StreamOutput::writeWriteable));
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeLong(this.queryStartTimeNanos);
        }
        if (out.getTransportVersion().supports(ESQL_SUPPORT_PARTIAL_RESULTS)) {
            out.writeBoolean(this.allowPartialResults);
        }
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public ZonedDateTime now() {
        return this.now;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String username() {
        return this.username;
    }

    public QueryPragmas pragmas() {
        return this.pragmas;
    }

    public int resultTruncationMaxSize() {
        return this.resultTruncationMaxSize;
    }

    public int resultTruncationDefaultSize() {
        return this.resultTruncationDefaultSize;
    }

    public Locale locale() {
        return this.locale;
    }

    public String query() {
        return this.query;
    }

    public long absoluteStartedTimeInMillis() {
        return this.now.toInstant().toEpochMilli();
    }

    public long getQueryStartTimeNanos() {
        return this.queryStartTimeNanos;
    }

    public FoldContext newFoldContext() {
        return new FoldContext(this.pragmas.foldLimit().getBytes());
    }

    public Map<String, Map<String, Column>> tables() {
        return this.tables;
    }

    public Configuration withoutTables() {
        return new Configuration(this.zoneId, this.locale, this.username, this.clusterName, this.pragmas, this.resultTruncationMaxSize, this.resultTruncationDefaultSize, this.query, this.profile, Map.of(), this.queryStartTimeNanos, this.allowPartialResults);
    }

    public boolean profile() {
        return this.profile;
    }

    public boolean allowPartialResults() {
        return this.allowPartialResults;
    }

    private static void writeQuery(StreamOutput out, String query) throws IOException {
        if (query.length() > QUERY_COMPRESS_THRESHOLD_CHARS) {
            out.writeBoolean(true);
            BytesArray bytesArray = new BytesArray(query.getBytes(StandardCharsets.UTF_8));
            BytesReference bytesRef = CompressorFactory.COMPRESSOR.compress((BytesReference)bytesArray);
            out.writeByteArray(bytesRef.array());
        } else {
            out.writeBoolean(false);
            out.writeString(query);
        }
    }

    private static String readQuery(StreamInput in) throws IOException {
        boolean compressed = in.readBoolean();
        if (compressed) {
            byte[] bytes = in.readByteArray();
            BytesReference bytesRef = CompressorFactory.uncompress((BytesReference)new BytesArray(bytes));
            return new String(bytesRef.array(), StandardCharsets.UTF_8);
        }
        return in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.now, that.now) && Objects.equals(this.username, that.username) && Objects.equals(this.clusterName, that.clusterName) && this.resultTruncationMaxSize == that.resultTruncationMaxSize && this.resultTruncationDefaultSize == that.resultTruncationDefaultSize && Objects.equals(this.pragmas, that.pragmas) && Objects.equals(this.locale, that.locale) && Objects.equals(that.query, this.query) && this.profile == that.profile && this.tables.equals(that.tables) && this.allowPartialResults == that.allowPartialResults;
    }

    public int hashCode() {
        return Objects.hash(this.zoneId, this.now, this.username, this.clusterName, this.pragmas, this.resultTruncationMaxSize, this.resultTruncationDefaultSize, this.locale, this.query, this.profile, this.tables, this.allowPartialResults);
    }

    public String toString() {
        return "EsqlConfiguration{pragmas=" + String.valueOf(this.pragmas) + ", resultTruncationMaxSize=" + this.resultTruncationMaxSize + ", resultTruncationDefaultSize=" + this.resultTruncationDefaultSize + ", locale=" + String.valueOf(this.locale) + ", query='" + this.query + "', profile=" + this.profile + ", tables=" + String.valueOf(this.tables) + "allow_partial_result=" + this.allowPartialResults + "}";
    }

    public static Configuration readWithoutTables(StreamInput in) throws IOException {
        BlockStreamInput blockStreamInput = new BlockStreamInput(in, null);
        return new Configuration(blockStreamInput);
    }
}

