/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class TimeSeriesSourceExec
extends LeafExec
implements EstimatesRowSize {
    private final List<Attribute> attrs;
    private final QueryBuilder query;
    private final Expression limit;
    private final Integer estimatedRowSize;

    public TimeSeriesSourceExec(Source source, List<Attribute> attrs, QueryBuilder query, Expression limit, Integer estimatedRowSize) {
        super(source);
        this.attrs = attrs;
        this.query = query;
        this.limit = limit;
        this.estimatedRowSize = estimatedRowSize;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("local plan");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("local plan");
    }

    protected NodeInfo<TimeSeriesSourceExec> info() {
        return NodeInfo.create((Node)this, TimeSeriesSourceExec::new, this.attrs, (Object)this.query, (Object)this.limit, (Object)this.estimatedRowSize);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public List<Attribute> attrs() {
        return this.attrs;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Expression limit() {
        return this.limit;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, 8);
        state.add(false, 22);
        state.add(false, 8);
        int size = state.consumeAllFields(false);
        if (Objects.equals(this.estimatedRowSize, size)) {
            return this;
        }
        return new TimeSeriesSourceExec(this.source(), this.attrs, this.query, this.limit, size);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attrs, this.query, this.limit, this.estimatedRowSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSeriesSourceExec other = (TimeSeriesSourceExec)obj;
        return Objects.equals(this.attrs, other.attrs) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize);
    }

    public String nodeString() {
        return this.nodeName() + "[query[" + (this.query != null ? Strings.toString((ToXContent)this.query, (boolean)false, (boolean)true) : "") + "] attributes: [" + NodeUtils.limitedToString(this.attrs) + "], estimatedRowSize[" + this.estimatedRowSize + "]";
    }
}

