/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TemporaryNameUtils;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public final class ReplaceAggregateAggExpressionWithEval
extends OptimizerRules.OptimizerRule<Aggregate> {
    public ReplaceAggregateAggExpressionWithEval() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected LogicalPlan rule(Aggregate aggregate) {
        AttributeMap.Builder aliasesBuilder = AttributeMap.builder();
        HashMap nonEvalGroupingAttributes = new HashMap(aggregate.groupings().size());
        aggregate.forEachExpressionUp(Alias.class, a -> {
            Expression patt0$temp = a.child();
            if (patt0$temp instanceof GroupingFunction.NonEvaluatableGroupingFunction) {
                GroupingFunction.NonEvaluatableGroupingFunction groupingFunction = (GroupingFunction.NonEvaluatableGroupingFunction)patt0$temp;
                nonEvalGroupingAttributes.put(groupingFunction, a.toAttribute());
            } else {
                aliasesBuilder.put(a.toAttribute(), (Object)a.child());
            }
        });
        AttributeMap aliases = aliasesBuilder.build();
        List<? extends NamedExpression> aggs = aggregate.aggregates();
        LinkedHashMap rootAggs = Maps.newLinkedHashMapWithExpectedSize((int)aggs.size());
        ArrayList<Alias> newEvals = new ArrayList<Alias>();
        ArrayList<Object> newProjections = new ArrayList<Object>();
        ArrayList<Object> newAggs = new ArrayList<Object>();
        Holder changed = new Holder((Object)false);
        int[] counter = new int[]{0};
        for (NamedExpression namedExpression : aggs) {
            if (namedExpression instanceof Alias) {
                Alias as = (Alias)namedExpression;
                Expression child = as.child();
                if (child instanceof AggregateFunction) {
                    AggregateFunction af2 = (AggregateFunction)child;
                    AggregateFunction canonical = (AggregateFunction)af2.canonical().transformUp(e -> (Expression)aliases.resolve(e, e));
                    Alias found = (Alias)rootAggs.get(canonical);
                    if (found == null) {
                        rootAggs.put(canonical, as);
                        newAggs.add(as);
                        newProjections.add(as.toAttribute());
                        continue;
                    }
                    changed.set((Object)true);
                    newProjections.add(as.replaceChild((Expression)found.toAttribute()));
                    continue;
                }
                changed.set((Object)true);
                Expression aggExpression = (Expression)child.transformUp(AggregateFunction.class, af -> {
                    AggregateFunction canonical = (AggregateFunction)af.canonical();
                    Alias alias = (Alias)rootAggs.get(canonical);
                    if (alias == null) {
                        int n = counter[0];
                        counter[0] = n + 1;
                        alias = new Alias(af.source(), ReplaceAggregateAggExpressionWithEval.syntheticName((Expression)canonical, child, n), (Expression)canonical, null, true);
                        rootAggs.put(canonical, alias);
                        newAggs.add(alias);
                    }
                    return alias.toAttribute();
                });
                aggExpression = (Expression)aggExpression.transformUp(GroupingFunction.NonEvaluatableGroupingFunction.class, nonEvalGroupingAttributes::get);
                Alias alias = as.replaceChild(aggExpression);
                newEvals.add(alias);
                newProjections.add(alias.toAttribute());
                continue;
            }
            newAggs.add(namedExpression);
            newProjections.add(namedExpression.toAttribute());
        }
        UnaryPlan plan = aggregate;
        if (((Boolean)changed.get()).booleanValue()) {
            Source source = aggregate.source();
            plan = aggregate.with(aggregate.child(), aggregate.groupings(), newAggs);
            if (newEvals.size() > 0) {
                plan = new Eval(source, plan, newEvals);
            }
            plan = new Project(source, plan, newProjections);
        }
        return plan;
    }

    private static String syntheticName(Expression expression, Expression af, int counter) {
        return TemporaryNameUtils.temporaryName(expression, af, counter);
    }
}

