/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.EntryExpression;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIpLeadingZerosDecimal;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIpLeadingZerosOctal;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIpLeadingZerosRejected;

public class ToIp
extends EsqlScalarFunction
implements SurrogateExpression,
OptionalArgument,
ConvertFunction {
    private static final String LEADING_ZEROS = "leading_zeros";
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry("leading_zeros", DataType.KEYWORD));
    private final Expression field;
    private final Expression options;

    @FunctionInfo(returnType={"ip"}, description="Converts an input string to an IP value.", examples={@Example(file="ip", tag="to_ip", explanation="Note that in this example, the last conversion of the string isn\u2019t possible.\nWhen this happens, the result is a `null` value. In this case a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:68: evaluation of [TO_IP(str2)] failed, treating result as null. Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n\n`\"java.lang.IllegalArgumentException: 'foo' is not an IP string literal.\"`"), @Example(file="ip", tag="to_ip_leading_zeros_octal", explanation="Parse v4 addresses with leading zeros as octal. Like `ping` or `ftp`.\n"), @Example(file="ip", tag="to_ip_leading_zeros_decimal", explanation="Parse v4 addresses with leading zeros as decimal. Java's `InetAddress.getByName`.\n")})
    public ToIp(Source source, @Param(name="field", type={"ip", "keyword", "text"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field, @MapParam(name="options", params={@MapParam.MapParamEntry(name="leading_zeros", type={"keyword"}, valueHint={"reject", "octal", "decimal"}, description="What to do with leading 0s in IPv4 addresses.")}, description="(Optional) Additional options.", optional=true) Expression options) {
        super(source, options == null ? List.of(field) : List.of(field, options));
        this.field = field;
        this.options = options;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public DataType dataType() {
        return DataType.IP;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToIp(this.source(), newChildren.get(0), newChildren.size() == 1 ? null : newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToIp::new, (Object)this.field, (Object)this.options);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        throw new UnsupportedOperationException("should be rewritten");
    }

    @Override
    public Expression surrogate() {
        return LeadingZeros.from((MapExpression)this.options).surrogate(this.source(), this.field);
    }

    @Override
    public Expression field() {
        return this.field;
    }

    @Override
    public Set<DataType> supportedTypes() {
        return ToIpLeadingZerosRejected.EVALUATORS.keySet();
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isTypeOrUnionType((Expression)this.field, ToIpLeadingZerosRejected.EVALUATORS::containsKey, (String)this.sourceText(), null, (String[])new String[]{AbstractConvertFunction.supportedTypesNames(this.supportedTypes())});
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.options == null) {
            return resolution;
        }
        resolution = TypeResolutions.isMapExpression((Expression)this.options, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        for (EntryExpression e : ((MapExpression)this.options).entryExpressions()) {
            if (e.key().dataType() != DataType.KEYWORD) {
                return new Expression.TypeResolution("map keys must be strings");
            }
            Expression expression = e.key();
            if (!(expression instanceof Literal)) {
                return new Expression.TypeResolution("map keys must be literals");
            }
            Literal keyl = (Literal)expression;
            String key = BytesRefs.toString((Object)keyl.value());
            DataType expected = ALLOWED_OPTIONS.get(key);
            if (expected == null) {
                return new Expression.TypeResolution("[" + key + "] is not a supported option");
            }
            if (e.value().dataType() != expected) {
                return new Expression.TypeResolution("[" + key + "] expects [" + String.valueOf(expected) + "] but was [" + String.valueOf(e.value().dataType()) + "]");
            }
            if (e.value() instanceof Literal) continue;
            return new Expression.TypeResolution("map values must be literals");
        }
        try {
            LeadingZeros.from((MapExpression)this.options);
        }
        catch (IllegalArgumentException e) {
            return new Expression.TypeResolution(e.getMessage());
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static enum LeadingZeros {
        REJECT{

            @Override
            public Expression surrogate(Source source, Expression field) {
                return new ToIpLeadingZerosRejected(source, field);
            }
        }
        ,
        DECIMAL{

            @Override
            public Expression surrogate(Source source, Expression field) {
                return new ToIpLeadingZerosDecimal(source, field);
            }
        }
        ,
        OCTAL{

            @Override
            public Expression surrogate(Source source, Expression field) {
                return new ToIpLeadingZerosOctal(source, field);
            }
        };


        public static LeadingZeros from(MapExpression exp) {
            if (exp == null) {
                return REJECT;
            }
            Expression e = (Expression)exp.keyFoldedMap().get(ToIp.LEADING_ZEROS);
            return e == null ? REJECT : LeadingZeros.from(BytesRefs.toString((Object)((Literal)e).value()));
        }

        public static LeadingZeros from(String str) {
            return switch (str) {
                case "reject" -> REJECT;
                case "octal" -> OCTAL;
                case "decimal" -> DECIMAL;
                default -> throw new IllegalArgumentException("Illegal leading_zeros [" + str + "]");
            };
        }

        public abstract Expression surrogate(Source var1, Expression var2);
    }
}

