/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;
import org.elasticsearch.xpack.esql.session.IndexResolver;

public final class QueryBuilderResolver {
    private QueryBuilderResolver() {
    }

    public static void resolveQueryBuilders(LogicalPlan plan, TransportActionServices services, ActionListener<LogicalPlan> listener) {
        boolean hasFullTextFunctions = plan.anyMatch(p -> {
            Holder hasFullTextFunction = new Holder((Object)false);
            p.forEachExpression(FullTextFunction.class, unused -> hasFullTextFunction.set((Object)true));
            return (Boolean)hasFullTextFunction.get();
        });
        if (hasFullTextFunctions) {
            Rewriteable.rewriteAndFetch((Rewriteable)new FullTextFunctionsRewritable(plan), (QueryRewriteContext)QueryBuilderResolver.queryRewriteContext(services, QueryBuilderResolver.indexNames(plan)), (ActionListener)listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)r.plan)));
        } else {
            listener.onResponse((Object)plan);
        }
    }

    private static QueryRewriteContext queryRewriteContext(TransportActionServices services, Set<String> indexNames) {
        ResolvedIndices resolvedIndices = ResolvedIndices.resolveWithIndexNamesAndOptions((String[])((String[])indexNames.toArray(String[]::new)), (IndicesOptions)IndexResolver.FIELD_CAPS_INDICES_OPTIONS, (ProjectMetadata)services.clusterService().state().metadata().getProject(), (IndexNameExpressionResolver)services.indexNameExpressionResolver(), (RemoteClusterService)services.transportService().getRemoteClusterService(), (long)System.currentTimeMillis());
        return services.searchService().getRewriteContext(System::currentTimeMillis, resolvedIndices, null);
    }

    private static Set<String> indexNames(LogicalPlan plan) {
        HashSet<String> indexNames = new HashSet<String>();
        plan.forEachDown(EsRelation.class, esRelation -> indexNames.addAll(esRelation.concreteIndices()));
        return indexNames;
    }

    private record FullTextFunctionsRewritable(LogicalPlan plan) implements Rewriteable<FullTextFunctionsRewritable>
    {
        public FullTextFunctionsRewritable rewrite(QueryRewriteContext ctx) throws IOException {
            Holder exceptionHolder = new Holder();
            Holder updated = new Holder((Object)false);
            LogicalPlan newPlan = (LogicalPlan)((Object)this.plan.transformExpressionsDown(FullTextFunction.class, f -> {
                QueryBuilder builder;
                QueryBuilder initial = builder = f.queryBuilder();
                builder = builder == null ? f.asQuery(LucenePushdownPredicates.DEFAULT, TranslatorHandler.TRANSLATOR_HANDLER).toQueryBuilder() : builder;
                try {
                    builder = builder.rewrite(ctx);
                }
                catch (IOException e) {
                    exceptionHolder.setIfAbsent((Object)e);
                }
                boolean rewritten = builder != initial;
                updated.set((Object)((Boolean)updated.get() != false || rewritten ? 1 : 0));
                return rewritten ? f.replaceQueryBuilder(builder) : f;
            }));
            if (exceptionHolder.get() != null) {
                throw (IOException)exceptionHolder.get();
            }
            return (Boolean)updated.get() != false ? new FullTextFunctionsRewritable(newPlan) : this;
        }
    }
}

