/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.voyageai.request.VoyageAIRequest;
import org.elasticsearch.xpack.inference.services.voyageai.request.VoyageAIRerankRequestEntity;
import org.elasticsearch.xpack.inference.services.voyageai.rerank.VoyageAIRerankModel;

public class VoyageAIRerankRequest
extends VoyageAIRequest {
    private final String query;
    private final List<String> input;
    private final Boolean returnDocuments;
    private final Integer topN;
    private final VoyageAIRerankModel model;

    public VoyageAIRerankRequest(String query, List<String> input, @Nullable Boolean returnDocuments, @Nullable Integer topN, VoyageAIRerankModel model) {
        this.model = Objects.requireNonNull(model);
        this.input = Objects.requireNonNull(input);
        this.query = Objects.requireNonNull(query);
        this.returnDocuments = returnDocuments;
        this.topN = topN;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.model.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new VoyageAIRerankRequestEntity(this.query, this.input, this.returnDocuments, this.topN, this.model.getTaskSettings(), this.model.getServiceSettings().modelId())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        VoyageAIRerankRequest.decorateWithHeaders(httpPost, this.model);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.model.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

