/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.mistral.embeddings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.mistral.MistralModel;
import org.elasticsearch.xpack.inference.services.mistral.action.MistralActionVisitor;
import org.elasticsearch.xpack.inference.services.mistral.embeddings.MistralEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class MistralEmbeddingsModel
extends MistralModel {
    public MistralEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, MistralEmbeddingsServiceSettings.fromMap(serviceSettings, context), (TaskSettings)EmptyTaskSettings.INSTANCE, chunkingSettings, DefaultSecretSettings.fromMap(secrets));
    }

    public MistralEmbeddingsModel(MistralEmbeddingsModel model, MistralEmbeddingsServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    private void setPropertiesFromServiceSettings(MistralEmbeddingsServiceSettings serviceSettings) {
        this.model = serviceSettings.modelId();
        this.rateLimitSettings = serviceSettings.rateLimitSettings();
        this.setEndpointUrl();
    }

    private void setEndpointUrl() {
        try {
            this.uri = new URI("https://api.mistral.ai/v1/embeddings");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public MistralEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, MistralEmbeddingsServiceSettings serviceSettings, TaskSettings taskSettings, ChunkingSettings chunkingSettings, DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)new EmptyTaskSettings(), chunkingSettings), new ModelSecrets((SecretSettings)secrets));
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    public MistralEmbeddingsServiceSettings getServiceSettings() {
        return (MistralEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public ExecutableAction accept(MistralActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }
}

