/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.completion;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AmazonBedrockChatCompletionServiceSettings
extends AmazonBedrockServiceSettings {
    public static final String NAME = "amazon_bedrock_chat_completion_service_settings";

    public static AmazonBedrockChatCompletionServiceSettings fromMap(Map<String, Object> serviceSettings, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        AmazonBedrockServiceSettings.BaseAmazonBedrockCommonSettings baseSettings = AmazonBedrockServiceSettings.fromMap(serviceSettings, validationException, context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AmazonBedrockChatCompletionServiceSettings(baseSettings.region(), baseSettings.model(), baseSettings.provider(), baseSettings.rateLimitSettings());
    }

    public AmazonBedrockChatCompletionServiceSettings(String region, String model, AmazonBedrockProvider provider, RateLimitSettings rateLimitSettings) {
        super(region, model, provider, rateLimitSettings);
    }

    public AmazonBedrockChatCompletionServiceSettings(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.addBaseXContent(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addXContentFragmentOfExposedFields(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonBedrockChatCompletionServiceSettings that = (AmazonBedrockChatCompletionServiceSettings)o;
        return Objects.equals(this.region, that.region) && Objects.equals((Object)this.provider, (Object)that.provider) && Objects.equals(this.model, that.model) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.region, this.model, this.provider, this.rateLimitSettings});
    }
}

