/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class TimedListener<Response> {
    private final ActionListener<Response> listenerWithTimeout;
    private final AtomicBoolean completed = new AtomicBoolean();

    public TimedListener(@Nullable TimeValue timeout, ActionListener<Response> listener, ThreadPool threadPool) {
        this.listenerWithTimeout = this.getListener(Objects.requireNonNull(listener), timeout, Objects.requireNonNull(threadPool));
    }

    private ActionListener<Response> getListener(ActionListener<Response> origListener, @Nullable TimeValue timeout, ThreadPool threadPool) {
        ActionListener notificationListener = ActionListener.wrap(result -> {
            this.completed.set(true);
            origListener.onResponse(result);
        }, e -> {
            this.completed.set(true);
            origListener.onFailure(e);
        });
        if (timeout == null) {
            return notificationListener;
        }
        return ListenerTimeouts.wrapWithTimeout((ThreadPool)threadPool, (TimeValue)timeout, (Executor)threadPool.executor("inference_utility"), (ActionListener)notificationListener, ignored -> notificationListener.onFailure((Exception)new ElasticsearchStatusException(Strings.format((String)"Request timed out after [%s]", (Object[])new Object[]{timeout}), RestStatus.REQUEST_TIMEOUT, new Object[0])));
    }

    public boolean hasCompleted() {
        return this.completed.get();
    }

    public ActionListener<Response> getListener() {
        return this.listenerWithTimeout;
    }
}

