/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpUtils;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public abstract class BaseResponseHandler
implements ResponseHandler {
    public static final String SERVER_ERROR = "Received a server error status code";
    public static final String RATE_LIMIT = "Received a rate limit status code";
    public static final String AUTHENTICATION = "Received an authentication error status code";
    public static final String PERMISSION_DENIED = "Received a permission denied error status code";
    public static final String REDIRECTION = "Unhandled redirection";
    public static final String CONTENT_TOO_LARGE = "Received a content too large status code";
    public static final String UNSUCCESSFUL = "Received an unsuccessful status code";
    public static final String SERVER_ERROR_OBJECT = "Received an error response";
    public static final String BAD_REQUEST = "Received a bad request status code";
    public static final String METHOD_NOT_ALLOWED = "Received a method not allowed status code";
    protected final String requestType;
    protected final ResponseParser parseFunction;
    private final Function<HttpResult, ErrorResponse> errorParseFunction;
    private final boolean canHandleStreamingResponses;

    public BaseResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction) {
        this(requestType, parseFunction, errorParseFunction, false);
    }

    public BaseResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction, boolean canHandleStreamingResponses) {
        this.requestType = Objects.requireNonNull(requestType);
        this.parseFunction = Objects.requireNonNull(parseFunction);
        this.errorParseFunction = Objects.requireNonNull(errorParseFunction);
        this.canHandleStreamingResponses = canHandleStreamingResponses;
    }

    @Override
    public boolean canHandleStreamingResponses() {
        return this.canHandleStreamingResponses;
    }

    @Override
    public InferenceServiceResults parseResult(Request request, HttpResult result) throws RetryException {
        try {
            return this.parseFunction.apply(request, result);
        }
        catch (Exception e) {
            throw new RetryException(true, e);
        }
    }

    @Override
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    public void validateResponse(ThrottlerManager throttlerManager, Logger logger, Request request, HttpResult result, boolean checkForErrorObject) {
        this.checkForFailureStatusCode(request, result);
        HttpUtils.checkForEmptyBody(throttlerManager, logger, request, result);
        if (checkForErrorObject) {
            this.checkForErrorObject(request, result);
        }
    }

    protected abstract void checkForFailureStatusCode(Request var1, HttpResult var2);

    private void checkForErrorObject(Request request, HttpResult result) {
        ErrorResponse errorEntity = this.errorParseFunction.apply(result);
        if (errorEntity.errorStructureFound()) {
            throw new RetryException(false, this.buildError(SERVER_ERROR_OBJECT, request, result, errorEntity));
        }
    }

    protected Exception buildError(String message, Request request, HttpResult result) {
        ErrorResponse errorEntityMsg = this.errorParseFunction.apply(result);
        return this.buildError(message, request, result, errorEntityMsg);
    }

    protected Exception buildError(String message, Request request, HttpResult result, ErrorResponse errorResponse) {
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        return new ElasticsearchStatusException(this.errorMessage(message, request, result, errorResponse, responseStatusCode), BaseResponseHandler.toRestStatus(responseStatusCode), new Object[0]);
    }

    protected String errorMessage(String message, Request request, HttpResult result, ErrorResponse errorResponse, int statusCode) {
        return errorResponse == null || !errorResponse.errorStructureFound() || org.elasticsearch.common.Strings.isNullOrEmpty((String)errorResponse.getErrorMessage()) ? Strings.format((String)"%s for request from inference entity id [%s] status [%s]", (Object[])new Object[]{message, request.getInferenceEntityId(), statusCode}) : Strings.format((String)"%s for request from inference entity id [%s] status [%s]. Error message: [%s]", (Object[])new Object[]{message, request.getInferenceEntityId(), statusCode, errorResponse.getErrorMessage()});
    }

    public static RestStatus toRestStatus(int statusCode) {
        RestStatus code = null;
        if (statusCode < 500) {
            code = RestStatus.fromCode((int)statusCode);
        }
        return code == null ? RestStatus.BAD_REQUEST : code;
    }
}

