/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.DeleteInferenceEndpointAction;
import org.elasticsearch.xpack.core.ml.utils.InferenceProcessorInfoExtractor;
import org.elasticsearch.xpack.inference.common.InferenceExceptions;
import org.elasticsearch.xpack.inference.common.SemanticTextInfoExtractor;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportDeleteInferenceEndpointAction
extends TransportMasterNodeAction<DeleteInferenceEndpointAction.Request, DeleteInferenceEndpointAction.Response> {
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private final Executor executor;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportDeleteInferenceEndpointAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/inference/delete", transportService, clusterService, threadPool, actionFilters, DeleteInferenceEndpointAction.Request::new, DeleteInferenceEndpointAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
        this.executor = threadPool.executor("inference_utility");
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, DeleteInferenceEndpointAction.Request request, ClusterState state, ActionListener<DeleteInferenceEndpointAction.Response> masterListener) {
        this.executor.execute((Runnable)ActionRunnable.wrap(masterListener, l -> this.doExecuteForked(request, state, (ActionListener<DeleteInferenceEndpointAction.Response>)l)));
    }

    private void doExecuteForked(DeleteInferenceEndpointAction.Request request, ClusterState state, ActionListener<DeleteInferenceEndpointAction.Response> masterListener) {
        SubscribableListener.newForked(modelConfigListener -> this.modelRegistry.getModel(request.getInferenceEndpointId(), (ActionListener<UnparsedModel>)modelConfigListener)).andThen((listener, unparsedModel) -> {
            Optional service;
            if (!request.getTaskType().isAnyOrSame(unparsedModel.taskType())) {
                listener.onFailure((Exception)InferenceExceptions.mismatchedTaskTypeException(request.getTaskType(), unparsedModel.taskType()));
                return;
            }
            if (request.isDryRun()) {
                TransportDeleteInferenceEndpointAction.handleDryRun(request, state, masterListener);
                return;
            }
            if (!request.isForceDelete()) {
                String errorString = TransportDeleteInferenceEndpointAction.endpointIsReferencedInPipelinesOrIndexes(state, request.getInferenceEndpointId());
                if (errorString != null) {
                    listener.onFailure((Exception)new ElasticsearchStatusException(errorString, RestStatus.CONFLICT, new Object[0]));
                    return;
                }
                if (this.isInferenceIdReserved(request.getInferenceEndpointId())) {
                    listener.onFailure((Exception)new ElasticsearchStatusException(Strings.format((String)"[%s] is a reserved inference endpoint. Use the force=true query parameter to delete the inference endpoint.", (Object[])new Object[]{request.getInferenceEndpointId()}), RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
            }
            if ((service = this.serviceRegistry.getService(unparsedModel.service())).isPresent()) {
                Model model = ((InferenceService)service.get()).parsePersistedConfig(unparsedModel.inferenceEntityId(), unparsedModel.taskType(), unparsedModel.settings());
                ((InferenceService)service.get()).stop(model, listener);
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException("No service found for this inference endpoint " + request.getInferenceEndpointId(), RestStatus.NOT_FOUND, new Object[0]));
            }
        }).andThen((listener, didStop) -> {
            if (didStop.booleanValue()) {
                this.modelRegistry.deleteModel(request.getInferenceEndpointId(), (ActionListener<Boolean>)listener);
            } else {
                listener.onFailure((Exception)new ElasticsearchStatusException("Failed to stop inference endpoint " + request.getInferenceEndpointId(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }).addListener(masterListener.delegateFailure((l3, didDeleteModel) -> masterListener.onResponse((Object)new DeleteInferenceEndpointAction.Response(didDeleteModel.booleanValue(), Set.of(), Set.of(), null))));
    }

    private static void handleDryRun(DeleteInferenceEndpointAction.Request request, ClusterState state, ActionListener<DeleteInferenceEndpointAction.Response> masterListener) {
        Set<String> pipelines = TransportDeleteInferenceEndpointAction.endpointIsReferencedInPipelines(state, request.getInferenceEndpointId());
        Set<String> indexesReferencedBySemanticText = TransportDeleteInferenceEndpointAction.endpointIsReferencedInIndex(state, request.getInferenceEndpointId());
        masterListener.onResponse((Object)new DeleteInferenceEndpointAction.Response(false, pipelines, indexesReferencedBySemanticText, TransportDeleteInferenceEndpointAction.buildErrorString(request.getInferenceEndpointId(), pipelines, indexesReferencedBySemanticText)));
    }

    private static String endpointIsReferencedInPipelinesOrIndexes(ClusterState state, String inferenceEndpointId) {
        Set<String> pipelines = TransportDeleteInferenceEndpointAction.endpointIsReferencedInPipelines(state, inferenceEndpointId);
        Set<String> indexes = TransportDeleteInferenceEndpointAction.endpointIsReferencedInIndex(state, inferenceEndpointId);
        if (!pipelines.isEmpty() || !indexes.isEmpty()) {
            return TransportDeleteInferenceEndpointAction.buildErrorString(inferenceEndpointId, pipelines, indexes);
        }
        return null;
    }

    private boolean isInferenceIdReserved(String inferenceEndpointId) {
        return this.modelRegistry.containsDefaultConfigId(inferenceEndpointId);
    }

    private static String buildErrorString(String inferenceEndpointId, Set<String> pipelines, Set<String> indexes) {
        StringBuilder errorString = new StringBuilder();
        if (!pipelines.isEmpty()) {
            errorString.append("Inference endpoint ").append(inferenceEndpointId).append(" is referenced by pipelines: ").append(pipelines).append(". ").append("Ensure that no pipelines are using this inference endpoint, ").append("or use force to ignore this warning and delete the inference endpoint.");
        }
        if (!indexes.isEmpty()) {
            if (!errorString.isEmpty()) {
                errorString.append(" ");
            }
            errorString.append("Inference endpoint ").append(inferenceEndpointId).append(" is being used in the mapping for indexes: ").append(indexes).append(". ").append("Ensure that no index mappings are using this inference endpoint, ").append("or use force to ignore this warning and delete the inference endpoint.");
        }
        return errorString.toString();
    }

    private static Set<String> endpointIsReferencedInIndex(ClusterState state, String inferenceEndpointId) {
        return SemanticTextInfoExtractor.extractIndexesReferencingInferenceEndpoints(state.getMetadata(), Set.of(inferenceEndpointId));
    }

    private static Set<String> endpointIsReferencedInPipelines(ClusterState state, String inferenceEndpointId) {
        return InferenceProcessorInfoExtractor.pipelineIdsForResource((Metadata)state.metadata(), Set.of(inferenceEndpointId));
    }

    protected ClusterBlockException checkBlock(DeleteInferenceEndpointAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.WRITE);
    }
}

