/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.search.SearchApplication;

public class PutSearchApplicationAction {
    public static final String NAME = "cluster:admin/xpack/application/search_application/put";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/application/search_application/put");

    private PutSearchApplicationAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        final DocWriteResponse.Result result;

        public Response(StreamInput in) throws IOException {
            this.result = DocWriteResponse.Result.readFrom((StreamInput)in);
        }

        public Response(DocWriteResponse.Result result) {
            this.result = result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.result.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("result", this.result.getLowercase());
            builder.endObject();
            return builder;
        }

        public RestStatus status() {
            return switch (this.result) {
                case DocWriteResponse.Result.CREATED -> RestStatus.CREATED;
                case DocWriteResponse.Result.NOT_FOUND -> RestStatus.NOT_FOUND;
                default -> RestStatus.OK;
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.result, that.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private final SearchApplication searchApp;
        private final boolean create;
        public static final ParseField SEARCH_APPLICATION = new ParseField("searchApp", new String[0]);
        public static final ParseField CREATE = new ParseField("create", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_search_application_request", false, params -> new Request((SearchApplication)params[0], (Boolean)params[1]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.searchApp = new SearchApplication(in);
            this.create = in.readBoolean();
        }

        public Request(String name, boolean create, BytesReference content, XContentType contentType) {
            this.searchApp = SearchApplication.fromXContentBytes(name, content, contentType);
            this.create = create;
        }

        public Request(SearchApplication app, boolean create) {
            this.searchApp = app;
            this.create = create;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.searchApp.indices().length == 0) {
                validationException = ValidateActions.addValidationError((String)"indices are missing", validationException);
            }
            if (this.searchApp.searchApplicationTemplateOrDefault().script() == null) {
                validationException = ValidateActions.addValidationError((String)"script required for template", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.searchApp.writeTo(out);
            out.writeBoolean(this.create);
        }

        public SearchApplication getSearchApplication() {
            return this.searchApp;
        }

        public boolean create() {
            return this.create;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.searchApp, that.searchApp) && this.create == that.create;
        }

        public int hashCode() {
            return Objects.hash(this.searchApp, this.create);
        }

        public static Request parse(XContentParser parser, String resourceName) {
            return (Request)((Object)PARSER.apply(parser, (Object)resourceName));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SEARCH_APPLICATION.getPreferredName(), (ToXContent)this.searchApp);
            builder.field(CREATE.getPreferredName(), this.create);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SearchApplication.fromXContent(c, p), SEARCH_APPLICATION);
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), CREATE);
        }
    }
}

