/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.trigger.Trigger;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;

public class ScheduleTrigger
implements Trigger {
    public static final String TYPE = "schedule";
    public static final String TIMEZONE_FIELD = "timezone";
    private final Schedule schedule;

    public ScheduleTrigger(Schedule schedule) {
        this.schedule = schedule;
    }

    public String type() {
        return TYPE;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTrigger trigger = (ScheduleTrigger)o;
        return this.schedule.equals(trigger.schedule);
    }

    public int hashCode() {
        return this.schedule.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        CronnableSchedule cronnableSchedule;
        builder.startObject();
        Schedule schedule = this.schedule;
        if (schedule instanceof CronnableSchedule && (cronnableSchedule = (CronnableSchedule)schedule).getTimeZone() != null) {
            builder.field(TIMEZONE_FIELD, cronnableSchedule.getTimeZone().getId());
        }
        builder.field(this.schedule.type(), (ToXContent)this.schedule, params);
        return builder.endObject();
    }

    public static Builder builder(Schedule schedule) {
        return new Builder(schedule);
    }

    public static class Builder
    implements Trigger.Builder<ScheduleTrigger> {
        private final Schedule schedule;

        private Builder(Schedule schedule) {
            this.schedule = schedule;
        }

        public ScheduleTrigger build() {
            return new ScheduleTrigger(this.schedule);
        }
    }
}

