/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.search.QueryParserHelper;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.StandardRetrieverBuilder;

public class MultiFieldsInnerRetrieverUtils {
    private MultiFieldsInnerRetrieverUtils() {
    }

    public static ActionRequestValidationException validateParams(List<CompoundRetrieverBuilder.RetrieverSource> innerRetrievers, @Nullable List<String> fields, @Nullable String query, String retrieverName, String retrieversParamName, String fieldsParamName, String queryParamName, ActionRequestValidationException validationException) {
        if (fields != null || query != null) {
            if (query == null) {
                return ValidateActions.addValidationError((String)String.format(Locale.ROOT, "[%s] [%s] must be provided when [%s] is specified", retrieverName, queryParamName, fieldsParamName), (ActionRequestValidationException)validationException);
            }
            if (query.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "[%s] [%s] cannot be empty", retrieverName, queryParamName), (ActionRequestValidationException)validationException);
            }
            if (fields != null && fields.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "[%s] [%s] cannot be empty", retrieverName, fieldsParamName), (ActionRequestValidationException)validationException);
            }
            if (!innerRetrievers.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "[%s] cannot combine [%s] and [%s]", retrieverName, retrieversParamName, queryParamName), (ActionRequestValidationException)validationException);
            }
        } else if (innerRetrievers.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "[%s] must provide [%s] or [%s]", retrieverName, retrieversParamName, queryParamName), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public static List<RetrieverBuilder> generateInnerRetrievers(@Nullable List<String> fieldsAndWeights, String query, Collection<IndexMetadata> indicesMetadata, Function<List<WeightedRetrieverSource>, CompoundRetrieverBuilder<?>> innerNormalizerGenerator, @Nullable Consumer<Float> weightValidator) {
        Map parsedFieldsAndWeights;
        Map map = parsedFieldsAndWeights = fieldsAndWeights != null ? QueryParserHelper.parseFieldsAndWeights(fieldsAndWeights) : Map.of();
        if (weightValidator != null) {
            parsedFieldsAndWeights.values().forEach(weightValidator);
        }
        ArrayList<RetrieverBuilder> innerRetrievers = new ArrayList<RetrieverBuilder>(indicesMetadata.size() * 2);
        for (IndexMetadata indexMetadata : indicesMetadata) {
            innerRetrievers.addAll(MultiFieldsInnerRetrieverUtils.generateInnerRetrieversForIndex(parsedFieldsAndWeights, query, indexMetadata, innerNormalizerGenerator, weightValidator));
        }
        return innerRetrievers;
    }

    private static List<RetrieverBuilder> generateInnerRetrieversForIndex(Map<String, Float> parsedFieldsAndWeights, String query, IndexMetadata indexMetadata, Function<List<WeightedRetrieverSource>, CompoundRetrieverBuilder<?>> innerNormalizerGenerator, @Nullable Consumer<Float> weightValidator) {
        Map fieldsAndWeightsToQuery = parsedFieldsAndWeights;
        if (fieldsAndWeightsToQuery.isEmpty()) {
            Settings settings = indexMetadata.getSettings();
            List defaultFields = settings.getAsList(IndexSettings.DEFAULT_FIELD_SETTING.getKey(), (List)IndexSettings.DEFAULT_FIELD_SETTING.getDefault(settings));
            fieldsAndWeightsToQuery = QueryParserHelper.parseFieldsAndWeights((List)defaultFields);
            if (weightValidator != null) {
                fieldsAndWeightsToQuery.values().forEach(weightValidator);
            }
        }
        HashMap<String, Float> inferenceFields = new HashMap<String, Float>();
        Map indexInferenceFields = indexMetadata.getInferenceFields();
        for (Map.Entry<String, Float> entry : fieldsAndWeightsToQuery.entrySet()) {
            String field = entry.getKey();
            Float weight = entry.getValue();
            if (Regex.isMatchAllPattern((String)field)) {
                indexInferenceFields.keySet().forEach(f -> MultiFieldsInnerRetrieverUtils.addToInferenceFieldsMap(inferenceFields, f, weight));
                continue;
            }
            if (Regex.isSimpleMatchPattern((String)field)) {
                indexInferenceFields.keySet().stream().filter(f -> Regex.simpleMatch((String)field, (String)f)).forEach(f -> MultiFieldsInnerRetrieverUtils.addToInferenceFieldsMap(inferenceFields, f, weight));
                continue;
            }
            if (!indexInferenceFields.containsKey(field)) continue;
            MultiFieldsInnerRetrieverUtils.addToInferenceFieldsMap(inferenceFields, field, weight);
        }
        HashMap nonInferenceFields = new HashMap(fieldsAndWeightsToQuery);
        nonInferenceFields.keySet().removeAll(inferenceFields.keySet());
        ArrayList<RetrieverBuilder> innerRetrievers = new ArrayList<RetrieverBuilder>(2);
        if (!nonInferenceFields.isEmpty()) {
            MultiMatchQueryBuilder nonInferenceFieldQueryBuilder = new MultiMatchQueryBuilder((Object)query, new String[0]).type(MultiMatchQueryBuilder.Type.MOST_FIELDS).fields(nonInferenceFields);
            innerRetrievers.add((RetrieverBuilder)new StandardRetrieverBuilder((QueryBuilder)nonInferenceFieldQueryBuilder));
        }
        if (!inferenceFields.isEmpty()) {
            ArrayList inferenceFieldRetrievers = new ArrayList(inferenceFields.size());
            inferenceFields.forEach((f, w) -> {
                StandardRetrieverBuilder retrieverBuilder = new StandardRetrieverBuilder((QueryBuilder)new MatchQueryBuilder(f, (Object)query));
                inferenceFieldRetrievers.add(new WeightedRetrieverSource(CompoundRetrieverBuilder.RetrieverSource.from((RetrieverBuilder)retrieverBuilder), w.floatValue()));
            });
            innerRetrievers.add((RetrieverBuilder)innerNormalizerGenerator.apply(inferenceFieldRetrievers));
        }
        return innerRetrievers;
    }

    private static void addToInferenceFieldsMap(Map<String, Float> inferenceFields, String field, Float weight) {
        inferenceFields.compute(field, (k, v) -> Float.valueOf(v == null ? weight.floatValue() : v.floatValue() * weight.floatValue()));
    }

    public record WeightedRetrieverSource(CompoundRetrieverBuilder.RetrieverSource retrieverSource, float weight) {
    }
}

