/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.downsampling;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.datastreams.lifecycle.downsampling.DeleteSourceAndAddDownsampleToDS;

public class DeleteSourceAndAddDownsampleIndexExecutor
extends SimpleBatchedExecutor<DeleteSourceAndAddDownsampleToDS, Void> {
    private static final Logger LOGGER = LogManager.getLogger(DeleteSourceAndAddDownsampleToDS.class);
    private final AllocationService allocationService;

    public DeleteSourceAndAddDownsampleIndexExecutor(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    public Tuple<ClusterState, Void> executeTask(DeleteSourceAndAddDownsampleToDS task, ClusterState clusterState) throws Exception {
        return Tuple.tuple((Object)task.execute(clusterState), null);
    }

    public void taskSucceeded(DeleteSourceAndAddDownsampleToDS task, Void unused) {
        LOGGER.trace("Updated cluster state and replaced index [{}] with index [{}] in data stream [{}]. Index [{}] was deleted", (Object)task.getSourceBackingIndex(), (Object)task.getDownsampleIndex(), (Object)task.getDataStreamName(), (Object)task.getSourceBackingIndex());
        task.getListener().onResponse(null);
    }

    public ClusterState afterBatchExecution(ClusterState clusterState, boolean clusterStateChanged) {
        if (clusterStateChanged) {
            return this.allocationService.reroute(clusterState, "deleted indices", AllocationActionListener.rerouteCompletionIsNotRequired());
        }
        return clusterState;
    }
}

