/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.GetDataStreamSettingsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamSettingsAction
extends TransportLocalProjectMetadataAction<GetDataStreamSettingsAction.Request, GetDataStreamSettingsAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportGetDataStreamSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/settings/get", actionFilters, transportService.getTaskManager(), clusterService, (Executor)threadPool.executor("management"), projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.settingsFilter = settingsFilter;
    }

    protected ClusterBlockException checkBlock(GetDataStreamSettingsAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_WRITE);
    }

    protected void localClusterStateOperation(Task task, GetDataStreamSettingsAction.Request request, ProjectState project, ActionListener<GetDataStreamSettingsAction.Response> listener) throws Exception {
        List dataStreamNames = this.indexNameExpressionResolver.dataStreamNames(this.clusterService.state(), IndicesOptions.DEFAULT, request.indices());
        Map dataStreamMap = project.metadata().dataStreams();
        ArrayList<GetDataStreamSettingsAction.DataStreamSettingsResponse> responseList = new ArrayList<GetDataStreamSettingsAction.DataStreamSettingsResponse>(dataStreamNames.size());
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = (DataStream)dataStreamMap.get(dataStreamName);
            Settings settings = this.settingsFilter.filter(dataStream.getSettings());
            Settings effectiveSettings = this.settingsFilter.filter(dataStream.getEffectiveSettings(project.metadata()));
            responseList.add(new GetDataStreamSettingsAction.DataStreamSettingsResponse(dataStreamName, settings, effectiveSettings));
        }
        listener.onResponse((Object)new GetDataStreamSettingsAction.Response(responseList));
    }
}

