/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;

public final class MMDBUtil {
    private static final byte[] DATABASE_TYPE_MARKER = "database_type".getBytes(StandardCharsets.UTF_8);
    private static final int BUFFER_SIZE = 2048;

    private MMDBUtil() {
    }

    public static String getDatabaseType(Path database) throws IOException {
        long fileSize = Files.size(database);
        try (InputStream in = Files.newInputStream(database, new OpenOption[0]);){
            int actualBytesRead;
            long skip = fileSize > 2048L ? fileSize - 2048L : 0L;
            long skipped = in.skip(skip);
            if (skipped != skip) {
                throw new IOException("failed to skip [" + skip + "] bytes while reading [" + String.valueOf(database) + "]");
            }
            byte[] tail = new byte[2048];
            int read = 0;
            do {
                actualBytesRead = in.read(tail, read, 2048 - read);
                read += actualBytesRead;
            } while (actualBytesRead > 0);
            int metadataOffset = -1;
            int markerOffset = 0;
            for (int i = 0; i < tail.length; ++i) {
                byte b = tail[i];
                markerOffset = b == DATABASE_TYPE_MARKER[markerOffset] ? ++markerOffset : 0;
                if (markerOffset != DATABASE_TYPE_MARKER.length) continue;
                metadataOffset = i + 1;
                break;
            }
            if (metadataOffset == -1) {
                throw new IOException("database type marker not found");
            }
            int offsetByte = MMDBUtil.fromBytes(tail[metadataOffset]);
            int type = offsetByte >>> 5;
            if (type != 2) {
                throw new IOException("type must be UTF-8 string");
            }
            int size = offsetByte & 0x1F;
            if (size == 29) {
                size = 29 + MMDBUtil.fromBytes(tail[metadataOffset + 1]);
                ++metadataOffset;
            } else if (size >= 30) {
                throw new IOException("database_type too long [size indicator == " + size + "]");
            }
            String string = new String(tail, metadataOffset + 1, size, StandardCharsets.UTF_8);
            return string;
        }
    }

    private static int fromBytes(byte b1) {
        return b1 & 0xFF;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isGzip(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            boolean bl;
            try (GZIPInputStream gzis = new GZIPInputStream(is);){
                ((InputStream)gzis).read();
                bl = true;
            }
            return bl;
        }
        catch (ZipException e) {
            return false;
        }
    }
}

