/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.nio.file.Path;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.geoip.stats.CacheStats;

public final class GeoIpCache {
    static final Object NO_RESULT = new Object(){

        public String toString() {
            return "NO_RESULT";
        }
    };
    private final LongSupplier relativeNanoTimeProvider;
    private final Cache<CacheKey, Object> cache;
    private final LongAdder hitsTimeInNanos = new LongAdder();
    private final LongAdder missesTimeInNanos = new LongAdder();

    GeoIpCache(long maxSize, LongSupplier relativeNanoTimeProvider) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("geoip max cache size must be 0 or greater");
        }
        this.relativeNanoTimeProvider = relativeNanoTimeProvider;
        this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
    }

    GeoIpCache(long maxSize) {
        this(maxSize, System::nanoTime);
    }

    <RESPONSE> RESPONSE putIfAbsent(ProjectId projectId, String ip, String databasePath, Function<String, RESPONSE> retrieveFunction) {
        CacheKey cacheKey = new CacheKey(projectId, ip, databasePath);
        long cacheStart = this.relativeNanoTimeProvider.getAsLong();
        Object response = this.cache.get((Object)cacheKey);
        long cacheRequestTime = this.relativeNanoTimeProvider.getAsLong() - cacheStart;
        if (response == null) {
            long retrieveStart = this.relativeNanoTimeProvider.getAsLong();
            response = retrieveFunction.apply(ip);
            if (response == null) {
                response = NO_RESULT;
            }
            this.cache.put((Object)cacheKey, response);
            long databaseRequestAndCachePutTime = this.relativeNanoTimeProvider.getAsLong() - retrieveStart;
            this.missesTimeInNanos.add(cacheRequestTime + databaseRequestAndCachePutTime);
        } else {
            this.hitsTimeInNanos.add(cacheRequestTime);
        }
        if (response == NO_RESULT) {
            return null;
        }
        return (RESPONSE)response;
    }

    Object get(ProjectId projectId, String ip, String databasePath) {
        CacheKey cacheKey = new CacheKey(projectId, ip, databasePath);
        return this.cache.get((Object)cacheKey);
    }

    public int purgeCacheEntriesForDatabase(ProjectId projectId, Path databaseFile) {
        String databasePath = databaseFile.toString();
        int counter = 0;
        for (CacheKey key : this.cache.keys()) {
            if (!key.projectId.equals((Object)projectId) || !key.databasePath.equals(databasePath)) continue;
            this.cache.invalidate((Object)key);
            ++counter;
        }
        return counter;
    }

    public int count() {
        return this.cache.count();
    }

    public CacheStats getCacheStats() {
        Cache.CacheStats stats = this.cache.stats();
        return new CacheStats(this.cache.count(), stats.getHits(), stats.getMisses(), stats.getEvictions(), TimeValue.nsecToMSec((long)this.hitsTimeInNanos.sum()), TimeValue.nsecToMSec((long)this.missesTimeInNanos.sum()));
    }

    private record CacheKey(ProjectId projectId, String ip, String databasePath) {
    }
}

