/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyUsageCalculator;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;

public class TransportGetLifecycleAction
extends TransportLocalProjectMetadataAction<GetLifecycleAction.Request, GetLifecycleAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ilm/get", actionFilters, transportService.getTaskManager(), clusterService, (Executor)threadPool.executor("management"), projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetLifecycleAction.Request::new, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected void localClusterStateOperation(Task task, GetLifecycleAction.Request request, ProjectState state, ActionListener<GetLifecycleAction.Response> listener) {
        assert (task instanceof CancellableTask) : "get lifecycle requests should be cancellable";
        CancellableTask cancellableTask = (CancellableTask)task;
        if (cancellableTask.notifyIfCancelled(listener)) {
            return;
        }
        ProjectMetadata project = state.metadata();
        IndexLifecycleMetadata metadata = (IndexLifecycleMetadata)project.custom("index_lifecycle");
        if (metadata == null) {
            if (request.getPolicyNames().length == 0) {
                listener.onResponse((Object)new GetLifecycleAction.Response(List.of()));
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{Arrays.toString(request.getPolicyNames())}));
            }
        } else {
            List<String> names = request.getPolicyNames().length == 0 ? List.of("*") : Arrays.asList(request.getPolicyNames());
            if (names.size() > 1 && names.stream().anyMatch(Regex::isSimpleMatchPattern)) {
                throw new IllegalArgumentException("wildcard only supports a single value, please use comma-separated values or a single wildcard value");
            }
            LifecyclePolicyUsageCalculator lifecyclePolicyUsageCalculator = new LifecyclePolicyUsageCalculator(this.indexNameExpressionResolver, project, names);
            LinkedHashMap<String, GetLifecycleAction.LifecyclePolicyResponseItem> policyResponseItemMap = new LinkedHashMap<String, GetLifecycleAction.LifecyclePolicyResponseItem>();
            for (String name : names) {
                if (Regex.isSimpleMatchPattern((String)name)) {
                    for (Map.Entry entry : metadata.getPolicyMetadatas().entrySet()) {
                        if (cancellableTask.notifyIfCancelled(listener)) {
                            return;
                        }
                        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)entry.getValue();
                        if (!Regex.simpleMatch((String)name, (String)((String)entry.getKey()))) continue;
                        policyResponseItemMap.put((String)entry.getKey(), new GetLifecycleAction.LifecyclePolicyResponseItem(policyMetadata.getPolicy(), policyMetadata.getVersion(), policyMetadata.getModifiedDateString(), lifecyclePolicyUsageCalculator.retrieveCalculatedUsage(policyMetadata.getName())));
                    }
                    continue;
                }
                LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)metadata.getPolicyMetadatas().get(name);
                if (policyMetadata == null) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{name}));
                    return;
                }
                policyResponseItemMap.put(name, new GetLifecycleAction.LifecyclePolicyResponseItem(policyMetadata.getPolicy(), policyMetadata.getVersion(), policyMetadata.getModifiedDateString(), lifecyclePolicyUsageCalculator.retrieveCalculatedUsage(policyMetadata.getName())));
            }
            ArrayList requestedPolicies = new ArrayList(policyResponseItemMap.values());
            listener.onResponse((Object)new GetLifecycleAction.Response(requestedPolicies));
        }
    }

    protected ClusterBlockException checkBlock(GetLifecycleAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

