/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.ilm.action.TransportMoveToStepAction;

public class RestMoveToStepAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_ilm/move/{name}"));
    }

    public String getName() {
        return "ilm_move_to_step_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        TransportMoveToStepAction.Request request;
        TimeValue masterNodeTimeout = RestUtils.getMasterNodeTimeout((RestRequest)restRequest);
        TimeValue ackTimeout = RestUtils.getAckTimeout((RestRequest)restRequest);
        String index = restRequest.param("name");
        try (XContentParser parser = restRequest.contentParser();){
            request = TransportMoveToStepAction.Request.parseRequest((currentStepKey, nextStepKey) -> new TransportMoveToStepAction.Request(masterNodeTimeout, ackTimeout, index, currentStepKey, nextStepKey), parser);
        }
        return channel -> client.execute(ILMActions.MOVE_TO_STEP, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

