/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldQuery;

public class StringScriptFieldTermsQuery
extends AbstractStringScriptFieldQuery {
    private final Set<String> terms;

    public StringScriptFieldTermsQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, Set<String> terms) {
        super(script, leafFactory, fieldName);
        this.terms = terms;
    }

    @Override
    protected boolean matches(List<String> values) {
        for (String value : values) {
            if (!this.terms.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            for (String term : this.terms) {
                visitor.consumeTerms((Query)this, new Term[]{new Term(this.fieldName(), term)});
            }
        }
    }

    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return this.terms.toString();
        }
        return this.fieldName() + ":" + String.valueOf(this.terms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.terms);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        StringScriptFieldTermsQuery other = (StringScriptFieldTermsQuery)((Object)obj);
        return this.terms.equals(other.terms);
    }

    Set<String> terms() {
        return this.terms;
    }
}

