/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http;

import java.util.Locale;

public enum HttpMethod {
    HEAD("HEAD"),
    GET("GET"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE");

    private final String method;

    private HttpMethod(String method) {
        this.method = method;
    }

    public String method() {
        return this.method;
    }

    public static HttpMethod parse(String value) {
        return switch (value = value.toUpperCase(Locale.ROOT)) {
            case "HEAD" -> HEAD;
            case "GET" -> GET;
            case "POST" -> POST;
            case "PUT" -> PUT;
            case "DELETE" -> DELETE;
            default -> throw new IllegalArgumentException("unsupported http method [" + value + "]");
        };
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

