/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;

public class Completion
extends InferencePlan<Completion>
implements TelemetryAware,
PostAnalysisVerificationAware {
    public static final String DEFAULT_OUTPUT_FIELD_NAME = "completion";
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Completion", Completion::new);
    private final Expression prompt;
    private final Attribute targetField;
    private List<Attribute> lazyOutput;

    public Completion(Source source, LogicalPlan child, Expression inferenceId, Expression prompt, Attribute targetField) {
        super(source, child, inferenceId);
        this.prompt = prompt;
        this.targetField = targetField;
    }

    public Completion(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.prompt);
        out.writeNamedWriteable((NamedWriteable)this.targetField);
    }

    public Expression prompt() {
        return this.prompt;
    }

    public Attribute targetField() {
        return this.targetField;
    }

    @Override
    public Completion withInferenceId(Expression newInferenceId) {
        return new Completion(this.source(), this.child(), newInferenceId, this.prompt, this.targetField);
    }

    @Override
    public Completion replaceChild(LogicalPlan newChild) {
        return new Completion(this.source(), newChild, this.inferenceId(), this.prompt, this.targetField);
    }

    @Override
    public TaskType taskType() {
        return TaskType.COMPLETION;
    }

    public String getWriteableName() {
        return Completion.ENTRY.name;
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(List.of(this.targetField), this.child().output());
        }
        return this.lazyOutput;
    }

    @Override
    public List<Attribute> generatedAttributes() {
        return List.of(this.targetField);
    }

    @Override
    public Completion withGeneratedNames(List<String> newNames) {
        this.checkNumberOfNewNames(newNames);
        return new Completion(this.source(), this.child(), this.inferenceId(), this.prompt, this.renameTargetField(newNames.get(0)));
    }

    private Attribute renameTargetField(String newName) {
        if (newName.equals(this.targetField.name())) {
            return this.targetField;
        }
        return this.targetField.withName(newName).withId(new NameId());
    }

    @Override
    protected AttributeSet computeReferences() {
        return this.prompt.references();
    }

    @Override
    public boolean expressionsResolved() {
        return super.expressionsResolved() && this.prompt.resolved() && this.targetField.resolved();
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        if (this.prompt.resolved() && !DataType.isString((DataType)this.prompt.dataType())) {
            failures.add(Failure.fail(this.prompt, "prompt must be of type [{}] but is [{}]", new Object[]{DataType.TEXT.typeName(), this.prompt.dataType().typeName()}));
        }
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Completion::new, (Object)((Object)this.child()), (Object)this.inferenceId(), (Object)this.prompt, (Object)this.targetField);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Completion completion = (Completion)o;
        return Objects.equals(this.prompt, completion.prompt) && Objects.equals(this.targetField, completion.targetField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prompt, this.targetField);
    }
}

