/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ItemSetBitSet;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionsLookupTable;

abstract class TransactionStore
implements Writeable,
Releasable,
Accountable {
    static final Comparator<Tuple<Long, Long>> ITEMS_BY_COUNT_COMPARATOR = new Comparator<Tuple<Long, Long>>(){

        @Override
        public int compare(Tuple<Long, Long> o1, Tuple<Long, Long> o2) {
            if (o1.v2() == o2.v2()) {
                return ((Long)o1.v1()).compareTo((Long)o2.v1());
            }
            return ((Long)o2.v2()).compareTo((Long)o1.v2());
        }
    };
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + RamUsageEstimator.shallowSizeOfInstance(ByteArrayStreamInput.class);
    protected final BigArrays bigArrays;
    protected final BytesRef scratchBytesRef = new BytesRef();
    protected final ByteArrayStreamInput scratchByteArrayStreamInput = new ByteArrayStreamInput();

    static Comparator<Long> compareItems(LongArray counts) {
        return (e1, e2) -> {
            long count2;
            long count1 = counts.get(e1.longValue());
            if (count1 == (count2 = counts.get(e2.longValue()))) {
                return Long.compare(e1, e2);
            }
            return Long.compare(count2, count1);
        };
    }

    TransactionStore(BigArrays bigArrays) {
        this.bigArrays = bigArrays;
    }

    BigArrays getBigArrays() {
        return this.bigArrays;
    }

    abstract long getTotalItemCount();

    abstract long getTotalTransactionCount();

    abstract long getFilteredTransactionCount();

    abstract BytesRefArray getItems();

    abstract LongArray getItemCounts();

    abstract BytesRefArray getTransactions();

    abstract LongArray getTransactionCounts();

    public Tuple<Integer, Object> getItem(long id) throws IOException {
        this.getItems().get(id, this.scratchBytesRef);
        this.scratchByteArrayStreamInput.reset(this.scratchBytesRef.bytes, this.scratchBytesRef.offset, this.scratchBytesRef.length);
        return new Tuple((Object)this.scratchByteArrayStreamInput.readVInt(), this.scratchByteArrayStreamInput.readGenericValue());
    }

    public long getUniqueTransactionCount() {
        return this.getTransactions().size();
    }

    public void getItem(long id, BytesRef dest) {
        this.getItems().get(id, dest);
    }

    public void getTransaction(long id, BytesRef dest) {
        this.getTransactions().get(id, dest);
    }

    public long getItemCount(long id) {
        return this.getItemCounts().get(id);
    }

    public long getTransactionCount(long id) {
        return this.getTransactionCounts().get(id);
    }

    public long getUniqueItemsCount() {
        return this.getItems().size();
    }

    public TopItemIds getTopItemIds(long n) {
        ArrayList<Object> idsHelperBuffer = new ArrayList<Object>();
        LongArray itemCounts = this.getItemCounts();
        for (long i = 0L; i < itemCounts.size(); ++i) {
            long count = itemCounts.get(i);
            if (count <= 0L) continue;
            idsHelperBuffer.add(Tuple.tuple((Object)i, (Object)count));
        }
        idsHelperBuffer.sort(ITEMS_BY_COUNT_COMPARATOR);
        long topN = Math.min(n, (long)idsHelperBuffer.size());
        LongArray sortedIds = this.bigArrays.newLongArray(topN);
        for (long i = 0L; i < topN; ++i) {
            sortedIds.set(i, ((Long)((Tuple)idsHelperBuffer.get((int)i)).v1()).longValue());
        }
        return new TopItemIds(sortedIds);
    }

    public TopTransactionIds getTopTransactionIds() {
        return this.getTopTransactionIds(this.getTransactions().size());
    }

    public TopTransactionIds getTopTransactionIds(long n) {
        ArrayList<Tuple> idsHelperBuffer = new ArrayList<Tuple>();
        LongArray transactionCounts = this.getTransactionCounts();
        for (long i = 0L; i < transactionCounts.size(); ++i) {
            long count = transactionCounts.get(i);
            if (count <= 0L) continue;
            idsHelperBuffer.add(Tuple.tuple((Object)i, (Object)count));
        }
        idsHelperBuffer.sort((e1, e2) -> ((Long)e2.v2()).compareTo((Long)e1.v2()));
        long topN = Math.min(n, (long)idsHelperBuffer.size());
        LongArray sortedIds = this.bigArrays.newLongArray(topN);
        for (long i = 0L; i < topN; ++i) {
            sortedIds.set(i, ((Long)((Tuple)idsHelperBuffer.get((int)i)).v1()).longValue());
        }
        return new TopTransactionIds(sortedIds);
    }

    public TopItemIds getTopItemIds() {
        return this.getTopItemIds(this.getItems().size());
    }

    public TransactionsLookupTable createLookupTableByTopTransactions(TopItemIds topItems, TopTransactionIds topTransactions) throws IOException {
        try (IntArray positions = this.bigArrays.newIntArray(topItems.size());){
            int i = 0;
            while ((long)i < topItems.size()) {
                positions.set(topItems.getItemIdAt(i), i);
                ++i;
            }
            BytesRefArray transactions = this.getTransactions();
            TransactionsLookupTable lookupTable = new TransactionsLookupTable(transactions.size(), this.bigArrays);
            ItemSetBitSet bitSet = new ItemSetBitSet();
            for (Long id : topTransactions) {
                bitSet.clear();
                transactions.get(id.longValue(), this.scratchBytesRef);
                this.scratchByteArrayStreamInput.reset(this.scratchBytesRef.bytes, this.scratchBytesRef.offset, this.scratchBytesRef.length);
                while (this.scratchByteArrayStreamInput.available() > 0) {
                    bitSet.set(1 + positions.get(this.scratchByteArrayStreamInput.readVLong()));
                }
                lookupTable.append(bitSet);
            }
            TransactionsLookupTable transactionsLookupTable = lookupTable;
            return transactionsLookupTable;
        }
    }

    public boolean transactionContainsAllIds(LongsRef ids, long transactionId) throws IOException {
        this.getTransactions().get(transactionId, this.scratchBytesRef);
        this.scratchByteArrayStreamInput.reset(this.scratchBytesRef.bytes, this.scratchBytesRef.offset, this.scratchBytesRef.length);
        int itemsLeft = ids.length;
        while (this.scratchByteArrayStreamInput.length() - this.scratchByteArrayStreamInput.getPosition() >= itemsLeft) {
            long item = this.scratchByteArrayStreamInput.readVLong();
            if (item != ids.longs[ids.length - itemsLeft] || --itemsLeft != 0) continue;
            return true;
        }
        return false;
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (long)this.scratchBytesRef.length + (long)this.scratchByteArrayStreamInput.length();
    }

    static class TopItemIds
    implements Iterable<Long>,
    Releasable {
        private final LongArray sortedItems;

        private TopItemIds(LongArray sortedItems) {
            this.sortedItems = sortedItems;
        }

        public IdIterator iterator() {
            return this.iterator(0);
        }

        public IdIterator iterator(int startIndex) {
            return new IdIterator(startIndex);
        }

        public long getItemIdAt(long index) {
            return this.sortedItems.get(index);
        }

        public long size() {
            return this.sortedItems.size();
        }

        public void close() {
            Releasables.close((Releasable)this.sortedItems);
        }

        class IdIterator
        implements Iterator<Long> {
            private int currentIndex;

            IdIterator(int startIndex) {
                this.currentIndex = startIndex;
            }

            @Override
            public boolean hasNext() {
                return (long)this.currentIndex < TopItemIds.this.sortedItems.size();
            }

            @Override
            public Long next() {
                return TopItemIds.this.sortedItems.get((long)this.currentIndex++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public int getIndex() {
                return this.currentIndex;
            }

            public void reset() {
                this.currentIndex = 0;
            }

            public void reset(int startIndex) {
                this.currentIndex = startIndex;
            }
        }
    }

    static class TopTransactionIds
    implements Iterable<Long>,
    Releasable {
        private final LongArray sortedTransactions;

        private TopTransactionIds(LongArray sortedTransactions) {
            this.sortedTransactions = sortedTransactions;
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private int currentIndex = 0;

                @Override
                public boolean hasNext() {
                    return (long)this.currentIndex < sortedTransactions.size();
                }

                @Override
                public Long next() {
                    return sortedTransactions.get((long)this.currentIndex++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public long size() {
            return this.sortedTransactions.size();
        }

        public long getItemIdAt(long index) {
            return this.sortedTransactions.get(index);
        }

        public void close() {
            Releasables.close((Releasable)this.sortedTransactions);
        }
    }
}

