/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.action.DeleteQueryRulesetAction;

public class TransportDeleteQueryRulesetAction
extends HandledTransportAction<DeleteQueryRulesetAction.Request, AcknowledgedResponse> {
    protected final QueryRulesIndexService systemIndexService;

    @Inject
    public TransportDeleteQueryRulesetAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/query_rules/delete", transportService, actionFilters, DeleteQueryRulesetAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new QueryRulesIndexService(client, clusterService.getClusterSettings());
    }

    protected void doExecute(Task task, DeleteQueryRulesetAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String rulesetId = request.rulesetId();
        this.systemIndexService.deleteQueryRuleset(rulesetId, (ActionListener<DeleteResponse>)listener.map(v -> AcknowledgedResponse.TRUE));
    }
}

