/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;

public class TransportDeleteLifecycleAction
extends TransportMasterNodeAction<DeleteLifecycleAction.Request, AcknowledgedResponse> {
    private final ProjectResolver projectResolver;

    @Inject
    public TransportDeleteLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super("cluster:admin/ilm/delete", transportService, clusterService, threadPool, actionFilters, DeleteLifecycleAction.Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, DeleteLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ProjectId projectId = this.projectResolver.getProjectId();
        this.submitUnbatchedTask("delete-lifecycle-" + request.getPolicyName(), (ClusterStateUpdateTask)new DeleteLifecyclePolicyTask(projectId, request, listener));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(DeleteLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("ilm");
    }

    public Set<String> modifiedKeys(DeleteLifecycleAction.Request request) {
        return Set.of(request.getPolicyName());
    }

    public static class DeleteLifecyclePolicyTask
    extends AckedClusterStateUpdateTask {
        private final ProjectId projectId;
        private final DeleteLifecycleAction.Request request;

        public DeleteLifecyclePolicyTask(ProjectId projectId, DeleteLifecycleAction.Request request, ActionListener<AcknowledgedResponse> listener) {
            super((AcknowledgedRequest)request, listener);
            this.projectId = projectId;
            this.request = request;
        }

        public ClusterState execute(ClusterState currentState) {
            String policyToDelete = this.request.getPolicyName();
            ProjectMetadata projectMetadata = currentState.metadata().getProject(this.projectId);
            List<String> indicesUsingPolicy = projectMetadata.indices().values().stream().filter(idxMeta -> policyToDelete.equals(idxMeta.getLifecyclePolicyName())).map(idxMeta -> idxMeta.getIndex().getName()).toList();
            if (!indicesUsingPolicy.isEmpty()) {
                throw new IllegalArgumentException("Cannot delete policy [" + this.request.getPolicyName() + "]. It is in use by one or more indices: " + String.valueOf(indicesUsingPolicy));
            }
            IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)projectMetadata.custom("index_lifecycle");
            if (currentMetadata == null || !currentMetadata.getPolicyMetadatas().containsKey(this.request.getPolicyName())) {
                throw new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{this.request.getPolicyName()});
            }
            TreeMap newPolicies = new TreeMap(currentMetadata.getPolicyMetadatas());
            newPolicies.remove(this.request.getPolicyName());
            IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, LifecycleOperationMetadata.currentILMMode((ProjectMetadata)projectMetadata));
            ProjectMetadata.Builder newProjectMetadata = ProjectMetadata.builder((ProjectMetadata)projectMetadata).putCustom("index_lifecycle", (Metadata.ProjectCustom)newMetadata);
            return ClusterState.builder((ClusterState)currentState).putProjectMetadata(newProjectMetadata).build();
        }
    }
}

