/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.mustache.MultiSearchTemplateResponse;
import org.elasticsearch.script.mustache.MustacheScriptEngine;
import org.elasticsearch.script.mustache.RestMultiSearchTemplateAction;
import org.elasticsearch.script.mustache.RestRenderSearchTemplateAction;
import org.elasticsearch.script.mustache.RestSearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.script.mustache.TransportMultiSearchTemplateAction;
import org.elasticsearch.script.mustache.TransportSearchTemplateAction;

public class MustachePlugin
extends Plugin
implements ScriptPlugin,
ActionPlugin,
SearchPlugin {
    public static final ActionType<SearchTemplateResponse> SEARCH_TEMPLATE_ACTION = new ActionType("indices:data/read/search/template");
    public static final ActionType<MultiSearchTemplateResponse> MULTI_SEARCH_TEMPLATE_ACTION = new ActionType("indices:data/read/msearch/template");

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new MustacheScriptEngine(settings);
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler(SEARCH_TEMPLATE_ACTION, TransportSearchTemplateAction.class), new ActionPlugin.ActionHandler(MULTI_SEARCH_TEMPLATE_ACTION, TransportMultiSearchTemplateAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return Arrays.asList(new RestHandler[]{new RestSearchTemplateAction(clusterSupportsFeature), new RestMultiSearchTemplateAction(settings), new RestRenderSearchTemplateAction()});
    }

    public List<Setting<?>> getSettings() {
        return List.of(MustacheScriptEngine.MUSTACHE_RESULT_SIZE_LIMIT);
    }
}

