/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.simulatedlatencyrepo;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.support.FilterBlobContainer;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

class LatencySimulatingBlobStoreRepository
extends FsRepository {
    private final Runnable simulator;

    protected LatencySimulatingBlobStoreRepository(ProjectId projectId, RepositoryMetadata metadata, Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, Runnable simulator) {
        super(projectId, metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings);
        this.simulator = simulator;
    }

    protected BlobStore createBlobStore() throws Exception {
        final BlobStore fsBlobStore = super.createBlobStore();
        return new BlobStore(){

            public BlobContainer blobContainer(BlobPath path) {
                BlobContainer blobContainer = fsBlobStore.blobContainer(path);
                return new LatencySimulatingBlobContainer(blobContainer);
            }

            public void close() throws IOException {
                fsBlobStore.close();
            }
        };
    }

    private class LatencySimulatingBlobContainer
    extends FilterBlobContainer {
        LatencySimulatingBlobContainer(BlobContainer delegate) {
            super(delegate);
        }

        public InputStream readBlob(OperationPurpose purpose, String blobName) throws IOException {
            LatencySimulatingBlobStoreRepository.this.simulator.run();
            return super.readBlob(purpose, blobName);
        }

        public InputStream readBlob(OperationPurpose purpose, String blobName, long position, long length) throws IOException {
            LatencySimulatingBlobStoreRepository.this.simulator.run();
            return super.readBlob(purpose, blobName, position, length);
        }

        protected BlobContainer wrapChild(BlobContainer child) {
            return new LatencySimulatingBlobContainer(child);
        }
    }
}

