/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;

public final class ReconfigurationProtocolServerSideUtils {
    private ReconfigurationProtocolServerSideUtils() {
    }

    public static ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto listReconfigurableProperties(List<String> reconfigurableProperties) {
        ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto.Builder builder = ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto.newBuilder();
        builder.addAllName(reconfigurableProperties);
        return builder.build();
    }

    public static ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto getReconfigurationStatus(ReconfigurationTaskStatus status) {
        ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto.Builder builder = ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto.newBuilder();
        builder.setStartTime(status.getStartTime());
        if (status.stopped()) {
            builder.setEndTime(status.getEndTime());
            assert (status.getStatus() != null);
            for (Map.Entry result : status.getStatus().entrySet()) {
                ReconfigurationProtocolProtos.GetReconfigurationStatusConfigChangeProto.Builder changeBuilder = ReconfigurationProtocolProtos.GetReconfigurationStatusConfigChangeProto.newBuilder();
                ReconfigurationUtil.PropertyChange change = (ReconfigurationUtil.PropertyChange)result.getKey();
                changeBuilder.setName(change.prop);
                changeBuilder.setOldValue(change.oldVal != null ? change.oldVal : "");
                if (change.newVal != null) {
                    changeBuilder.setNewValue(change.newVal);
                }
                if (((Optional)result.getValue()).isPresent()) {
                    changeBuilder.setErrorMessage((String)((Optional)result.getValue()).get());
                }
                builder.addChanges(changeBuilder);
            }
        }
        return builder.build();
    }
}

