/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.List;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.StringUtils;

class UpdateBulkFactory
extends AbstractBulkFactory {
    private final int RETRY_ON_FAILURE;
    private final String RETRY_HEADER;
    private final String SCRIPT_2X;
    private final String SCRIPT_5X;
    private final String SCRIPT_LANG_5X;
    private final String SCRIPT_1X;
    private final String SCRIPT_LANG_1X;
    private final boolean HAS_SCRIPT;
    private final boolean HAS_LANG;
    private final boolean HAS_SCRIPT_UPSERT;
    private final boolean UPSERT;

    public UpdateBulkFactory(Settings settings, MetadataExtractor metaExtractor, EsMajorVersion esMajorVersion) {
        this(settings, false, metaExtractor, esMajorVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpdateBulkFactory(Settings settings, boolean upsert, MetadataExtractor metaExtractor, EsMajorVersion esMajorVersion) {
        super(settings, metaExtractor, esMajorVersion);
        this.UPSERT = upsert;
        this.RETRY_ON_FAILURE = settings.getUpdateRetryOnConflict();
        this.RETRY_HEADER = this.getRequestParameterNames().retryOnConflict + this.RETRY_ON_FAILURE + "";
        this.HAS_SCRIPT = settings.hasUpdateScript();
        this.HAS_SCRIPT_UPSERT = settings.hasScriptUpsert();
        this.HAS_LANG = StringUtils.hasText(settings.getUpdateScriptLang());
        this.SCRIPT_LANG_5X = ",\"lang\":\"" + settings.getUpdateScriptLang() + "\"";
        this.SCRIPT_LANG_1X = "\"lang\":\"" + settings.getUpdateScriptLang() + "\",";
        if (this.HAS_SCRIPT) {
            if (StringUtils.hasText(settings.getUpdateScriptInline())) {
                String source = "inline";
                if (esMajorVersion.onOrAfter(EsMajorVersion.V_6_X)) {
                    source = "source";
                }
                this.SCRIPT_2X = this.SCRIPT_5X = "{\"script\":{\"" + source + "\":\"" + settings.getUpdateScriptInline() + "\"";
                this.SCRIPT_1X = "\"script\":\"" + settings.getUpdateScriptInline() + "\"";
                return;
            } else if (StringUtils.hasText(settings.getUpdateScriptFile())) {
                this.SCRIPT_2X = this.SCRIPT_5X = "{\"script\":{\"file\":\"" + settings.getUpdateScriptFile() + "\"";
                this.SCRIPT_1X = "\"script_file\":\"" + settings.getUpdateScriptFile() + "\"";
                return;
            } else {
                if (!StringUtils.hasText(settings.getUpdateScriptStored())) throw new EsHadoopIllegalStateException("No update script found...");
                this.SCRIPT_5X = "{\"script\":{\"stored\":\"" + settings.getUpdateScriptStored() + "\"";
                this.SCRIPT_2X = "{\"script\":{\"id\":\"" + settings.getUpdateScriptStored() + "\"";
                this.SCRIPT_1X = "\"script_id\":\"" + settings.getUpdateScriptStored() + "\"";
            }
            return;
        } else {
            this.SCRIPT_5X = null;
            this.SCRIPT_2X = null;
            this.SCRIPT_1X = null;
        }
    }

    @Override
    protected String getOperation() {
        return "update";
    }

    @Override
    protected void otherHeader(List<Object> list, boolean commaMightBeNeeded) {
        if (this.RETRY_ON_FAILURE > 0) {
            if (commaMightBeNeeded) {
                list.add(",");
            }
            list.add(this.RETRY_HEADER);
        }
    }

    @Override
    protected void writeObjectHeader(List<Object> list) {
        super.writeObjectHeader(list);
        FieldExtractor paramExtractor = this.getMetadataExtractorOrFallback(MetadataExtractor.Metadata.PARAMS, this.getParamExtractor());
        if (this.esMajorVersion.on(EsMajorVersion.V_1_X)) {
            this.writeLegacyFormatting(list, paramExtractor);
        } else if (this.esMajorVersion.on(EsMajorVersion.V_2_X)) {
            this.writeStrictFormatting(list, paramExtractor, this.SCRIPT_2X);
        } else {
            this.writeStrictFormatting(list, paramExtractor, this.SCRIPT_5X);
        }
    }

    private void writeLegacyFormatting(List<Object> list, Object paramExtractor) {
        if (paramExtractor != null) {
            list.add("{\"params\":");
            list.add(paramExtractor);
            list.add(",");
        } else {
            list.add("{");
        }
        if (this.HAS_SCRIPT) {
            if (this.HAS_LANG) {
                list.add(this.SCRIPT_LANG_1X);
            }
            list.add(this.SCRIPT_1X);
            if (this.HAS_SCRIPT_UPSERT) {
                list.add(",\"scripted_upsert\": true");
            }
            if (this.UPSERT) {
                list.add(",\"upsert\":");
            }
        } else {
            if (this.UPSERT) {
                list.add("\"doc_as_upsert\":true,");
            }
            list.add("\"doc\":");
        }
    }

    private void writeStrictFormatting(List<Object> list, Object paramExtractor, String scriptToUse) {
        if (this.HAS_SCRIPT) {
            list.add(scriptToUse);
            if (this.HAS_LANG) {
                list.add(this.SCRIPT_LANG_5X);
            }
            if (paramExtractor != null) {
                list.add(",\"params\":");
                list.add(paramExtractor);
            }
            list.add("}");
            if (this.HAS_SCRIPT_UPSERT) {
                list.add(",\"scripted_upsert\": true");
            }
            if (this.UPSERT) {
                list.add(",\"upsert\":");
            }
        } else {
            list.add("{");
            if (this.UPSERT) {
                list.add("\"doc_as_upsert\":true,");
            }
            list.add("\"doc\":");
        }
    }

    @Override
    protected void writeObjectEnd(List<Object> after) {
        after.add("}");
        super.writeObjectEnd(after);
    }

    @Override
    protected boolean id(List<Object> list, boolean commaMightBeNeeded) {
        boolean added = super.id(list, commaMightBeNeeded);
        Assert.isTrue(added, String.format("Operation [%s] requires an id but none was given/found", this.getOperation()));
        return added;
    }
}

