/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.ChunkedInputStream;

public class ContentLengthInputStream
extends InputStream {
    private long contentLength;
    private long pos = 0L;
    private boolean closed = false;
    private InputStream wrappedStream = null;

    public ContentLengthInputStream(InputStream in, int contentLength) {
        this(in, (long)contentLength);
    }

    public ContentLengthInputStream(InputStream in, long contentLength) {
        this.wrappedStream = in;
        this.contentLength = contentLength;
    }

    public void close() throws IOException {
        if (!this.closed) {
            try {
                ChunkedInputStream.exhaustInputStream(this);
                Object var2_1 = null;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closed = true;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        ++this.pos;
        return this.wrappedStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        if (this.pos + (long)len > this.contentLength) {
            len = (int)(this.contentLength - this.pos);
        }
        int count = this.wrappedStream.read(b, off, len);
        this.pos += (long)count;
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long length = Math.min(n, this.contentLength - this.pos);
        if ((length = this.wrappedStream.skip(length)) > 0L) {
            this.pos += length;
        }
        return length;
    }
}

