/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import org.logstash.settings.Coercible;

public class SettingNumeric
extends Coercible<Number> {
    public SettingNumeric(String name, Number defaultValue) {
        super(name, defaultValue, true, SettingNumeric.noValidator());
    }

    public SettingNumeric(String name, Number defaultValue, boolean strict) {
        super(name, defaultValue, strict, SettingNumeric.noValidator());
    }

    @Override
    public Number coerce(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Failed to coerce value to SettingNumeric. Received null");
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(obj.toString()));
            }
            catch (NumberFormatException numberFormatException2) {
                throw new IllegalArgumentException(this.coercionFailureMessage(obj));
            }
        }
    }

    private String coercionFailureMessage(Object obj) {
        return String.format("Failed to coerce value to SettingNumeric. Received %s (%s)", obj, obj.getClass());
    }
}

