/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph.algorithms;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.logstash.config.ir.graph.Vertex;

public class BreadthFirst {
    public static BfsResult breadthFirst(Collection<Vertex> roots) {
        return BreadthFirst.breadthFirst(roots, false, null);
    }

    public static BfsResult breadthFirst(Collection<Vertex> roots, boolean reverse, Consumer<Map.Entry<Vertex, Integer>> consumer) {
        HashMap<Vertex, Integer> vertexDistances = new HashMap<Vertex, Integer>();
        HashMap vertexParents = new HashMap();
        ArrayDeque<Vertex> queue = new ArrayDeque<Vertex>(roots);
        roots.forEach(v -> vertexDistances.put((Vertex)v, 0));
        while (!queue.isEmpty()) {
            Vertex currentVertex = (Vertex)queue.removeFirst();
            Integer currentDistance = (Integer)vertexDistances.get(currentVertex);
            if (consumer != null) {
                consumer.accept(new AbstractMap.SimpleImmutableEntry<Vertex, Integer>(currentVertex, currentDistance));
            }
            Stream<Vertex> nextVertices = reverse ? currentVertex.incomingVertices() : currentVertex.outgoingVertices();
            nextVertices.forEach(nextVertex -> {
                if (vertexDistances.get(nextVertex) == null) {
                    vertexDistances.put((Vertex)nextVertex, currentDistance + 1);
                    vertexParents.put(nextVertex, currentVertex);
                    queue.push((Vertex)nextVertex);
                }
            });
        }
        return new BfsResult(vertexDistances);
    }

    public static final class BfsResult {
        public final Map<Vertex, Integer> vertexDistances;

        BfsResult(Map<Vertex, Integer> vertexDistances) {
            this.vertexDistances = vertexDistances;
        }

        public Collection<Vertex> getVertices() {
            return this.vertexDistances.keySet();
        }
    }
}

