/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.tls.AbstractTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSRPIdentityManager;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;

public class SRPTlsServer
extends AbstractTlsServer {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters srpLoginParameters = null;

    public SRPTlsServer(TlsCrypto tlsCrypto, TlsSRPIdentityManager tlsSRPIdentityManager) {
        super(tlsCrypto);
        this.srpIdentityManager = tlsSRPIdentityManager;
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    public void processClientExtensions(Hashtable hashtable) throws IOException {
        super.processClientExtensions(hashtable);
        this.srpIdentity = TlsSRPUtils.getSRPExtension(hashtable);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        int n = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite(n)) {
            if (this.srpIdentity != null) {
                this.srpLoginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.srpLoginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return n;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n = this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm();
        switch (n) {
            case 21: {
                return null;
            }
            case 22: {
                return this.getDSASignerCredentials();
            }
            case 23: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsSRPLoginParameters getSRPLoginParameters() throws IOException {
        return this.srpLoginParameters;
    }
}

