/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.watcher;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DeleteWatchResponse
extends ActionResponse
implements ToXContentObject {
    private final String id;
    private final long version;
    private final boolean found;

    public DeleteWatchResponse(String id, long version, boolean found) {
        this.id = id;
        this.version = version;
        this.found = found;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isFound() {
        return this.found;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteWatchResponse that = (DeleteWatchResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.found, that.found);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.found);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeVLong(this.version);
        out.writeBoolean(this.found);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("_id", this.id).field("_version", this.version).field("found", this.found).endObject();
    }
}

