/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StringStatsAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean showDistribution;
    public static final JsonpDeserializer<StringStatsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StringStatsAggregation::setupStringStatsAggregationDeserializer);

    private StringStatsAggregation(Builder builder) {
        super(builder);
        this.showDistribution = builder.showDistribution;
    }

    public static StringStatsAggregation of(Function<Builder, ObjectBuilder<StringStatsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.StringStats;
    }

    @Nullable
    public final Boolean showDistribution() {
        return this.showDistribution;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.showDistribution != null) {
            generator.writeKey("show_distribution");
            generator.write(this.showDistribution);
        }
    }

    protected static void setupStringStatsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::showDistribution, JsonpDeserializer.booleanDeserializer(), "show_distribution");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StringStatsAggregation> {
        @Nullable
        private Boolean showDistribution;

        public final Builder showDistribution(@Nullable Boolean value) {
            this.showDistribution = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StringStatsAggregation build() {
            this._checkSingleUse();
            return new StringStatsAggregation(this);
        }
    }
}

