/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplingQuery;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public record SamplingContext(double probability, int seed, Integer shardSeed) {
    public static final SamplingContext NONE = new SamplingContext(1.0, 0, null);

    public boolean isSampled() {
        return this.probability < 1.0;
    }

    public long scaleDown(long value) {
        if (this.isSampled()) {
            return Math.round((double)value * this.probability);
        }
        return value;
    }

    public long scaleUp(long value) {
        if (this.isSampled()) {
            return Math.round((double)value * (1.0 / this.probability));
        }
        return value;
    }

    public double scaleDown(double value) {
        if (this.isSampled()) {
            return value * this.probability;
        }
        return value;
    }

    public double scaleUp(double value) {
        if (this.isSampled()) {
            return value / this.probability;
        }
        return value;
    }

    public Query buildQueryWithSampler(QueryBuilder builder, AggregationContext context) throws IOException {
        Query rewritten = context.buildQuery(builder);
        if (!this.isSampled()) {
            return rewritten;
        }
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(rewritten, BooleanClause.Occur.FILTER);
        queryBuilder.add(new RandomSamplingQuery(this.probability(), this.seed(), this.shardSeed == null ? context.shardRandomSeed() : this.shardSeed.intValue()), BooleanClause.Occur.FILTER);
        return queryBuilder.build();
    }

    public Optional<Query> buildSamplingQueryIfNecessary(AggregationContext context) {
        if (!this.isSampled()) {
            return Optional.empty();
        }
        return Optional.of(new RandomSamplingQuery(this.probability(), this.seed(), this.shardSeed == null ? context.shardRandomSeed() : this.shardSeed.intValue()));
    }
}

