/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license.internal;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class TrialLicenseVersion
implements ToXContentFragment,
Writeable {
    static final int CURRENT_TRIAL_VERSION = 9000000;
    public static final TrialLicenseVersion CURRENT = new TrialLicenseVersion(9000000);
    private final int trialVersion;

    public TrialLicenseVersion(int trialVersion) {
        this.trialVersion = trialVersion;
    }

    public TrialLicenseVersion(StreamInput in) throws IOException {
        this.trialVersion = in.readVInt();
    }

    public static TrialLicenseVersion fromXContent(String from) {
        try {
            return new TrialLicenseVersion(Integer.parseInt(from));
        }
        catch (NumberFormatException ex) {
            return new TrialLicenseVersion(TrialLicenseVersion.parseVersionString(from));
        }
    }

    private static int parseVersionString(String version) {
        String[] parts;
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length != 3) {
            throw new IllegalArgumentException("unable to parse trial license version: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            return major + minor + revision + 99;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse trial license version: " + version, e);
        }
    }

    int asInt() {
        return this.trialVersion;
    }

    public boolean ableToStartNewTrial() {
        assert (this.trialVersion <= TrialLicenseVersion.CURRENT.trialVersion) : "trial version [" + this.trialVersion + "] cannot be greater than CURRENT [" + TrialLicenseVersion.CURRENT.trialVersion + "]";
        return this.trialVersion != TrialLicenseVersion.CURRENT.trialVersion;
    }

    public String toString() {
        return Integer.toString(this.trialVersion);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.trialVersion);
    }

    String asVersionString() {
        return String.valueOf(this) + ".0.0";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrialLicenseVersion that = (TrialLicenseVersion)o;
        return this.trialVersion == that.trialVersion;
    }

    public int hashCode() {
        return Objects.hash(this.trialVersion);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.trialVersion);
    }
}

