/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class ScriptProcessor
extends AbstractProcessor {
    public static final String TYPE = "script";
    private final Script script;
    private final ScriptService scriptService;
    private final IngestScript.Factory precompiledIngestScriptFactory;

    ScriptProcessor(String tag, String description, Script script, @Nullable IngestScript.Factory precompiledIngestScriptFactory, ScriptService scriptService) {
        super(tag, description);
        this.script = script;
        this.precompiledIngestScriptFactory = precompiledIngestScriptFactory;
        this.scriptService = scriptService;
    }

    @Override
    public IngestDocument execute(IngestDocument document) {
        document.doNoSelfReferencesCheck(true);
        IngestScript.Factory factory = this.precompiledIngestScriptFactory;
        if (factory == null) {
            factory = this.scriptService.compile(this.script, IngestScript.CONTEXT);
        }
        factory.newInstance(this.script.getParams(), document.getCtxMap()).execute();
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    Script getScript() {
        return this.script;
    }

    IngestScript.Factory getPrecompiledIngestScriptFactory() {
        return this.precompiledIngestScriptFactory;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public ScriptProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            try (XContentBuilder builder = XContentBuilder.builder(JsonXContent.jsonXContent).map(config);){
                ScriptProcessor scriptProcessor;
                block15: {
                    XContentParser parser = XContentHelper.createParserNotCompressed(XContentParserConfiguration.EMPTY.withDeprecationHandler(LoggingDeprecationHandler.INSTANCE), BytesReference.bytes(builder), XContentType.JSON);
                    try {
                        Script script = Script.parse(parser);
                        Arrays.asList("id", "source", "inline", "lang", "params", "options").forEach(config::remove);
                        IngestScript.Factory ingestScriptFactory = null;
                        try {
                            ingestScriptFactory = this.scriptService.compile(script, IngestScript.CONTEXT);
                            if (ScriptType.STORED.equals(script.getType())) {
                                ingestScriptFactory = null;
                            }
                        }
                        catch (ScriptException e) {
                            throw ConfigurationUtils.newConfigurationException(ScriptProcessor.TYPE, processorTag, null, e);
                        }
                        scriptProcessor = new ScriptProcessor(processorTag, description, script, ingestScriptFactory, this.scriptService);
                        if (parser == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return scriptProcessor;
            }
        }
    }
}

