/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.LeafPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.plain.AbstractPointIndexFieldData;
import org.elasticsearch.index.fielddata.plain.LatLonPointDVLeafFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class LatLonPointIndexFieldData
extends AbstractPointIndexFieldData<MultiGeoPointValues>
implements IndexGeoPointFieldData {
    public LatLonPointIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ToScriptFieldFactory<MultiGeoPointValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, toScriptFieldFactory);
    }

    @Override
    public LeafPointFieldData<MultiGeoPointValues> load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.fieldName);
        if (info != null) {
            LatLonPointIndexFieldData.checkCompatible(info);
        }
        return new LatLonPointDVLeafFieldData(reader, this.fieldName, this.toScriptFieldFactory);
    }

    @Override
    public LeafPointFieldData<MultiGeoPointValues> loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != LatLonDocValuesField.TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + String.valueOf((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + String.valueOf((Object)LatLonDocValuesField.TYPE.docValuesType()) + ", is the field really a LatLonDocValuesField?");
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;
        private final ToScriptFieldFactory<MultiGeoPointValues> toScriptFieldFactory;

        public Builder(String name, ValuesSourceType valuesSourceType, ToScriptFieldFactory<MultiGeoPointValues> toScriptFieldFactory) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        @Override
        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new LatLonPointIndexFieldData(this.name, this.valuesSourceType, this.toScriptFieldFactory);
        }
    }
}

