/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.CloseUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndexRemovalReason;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class MetadataIndexAliasesService {
    private final IndicesService indicesService;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterStateTaskExecutor<ApplyAliasesTask> executor;
    private final MasterServiceTaskQueue<ApplyAliasesTask> taskQueue;
    private final ClusterService clusterService;

    @Inject
    public MetadataIndexAliasesService(ClusterService clusterService, IndicesService indicesService, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.xContentRegistry = xContentRegistry;
        this.executor = new SimpleBatchedAckListenerTaskExecutor<ApplyAliasesTask>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(ApplyAliasesTask applyAliasesTask, ClusterState clusterState) {
                return new Tuple<ClusterState, ClusterStateAckListener>(MetadataIndexAliasesService.this.applyAliasActions(clusterState.projectState(applyAliasesTask.request().projectId()), applyAliasesTask.request().actions()), applyAliasesTask);
            }
        };
        this.taskQueue = clusterService.createTaskQueue("index-aliases", Priority.URGENT, this.executor);
    }

    public void indicesAliases(IndicesAliasesClusterStateUpdateRequest request, ActionListener<IndicesAliasesResponse> listener) {
        this.taskQueue.submitTask("index-aliases", new ApplyAliasesTask(request, listener), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState applyAliasActions(ProjectState projectState, Iterable<AliasAction> actions) {
        ClusterState currentState = projectState.cluster();
        ProjectId projectId = projectState.projectId();
        ArrayList indicesToClose = new ArrayList();
        HashMap indices = new HashMap();
        ProjectMetadata currentProjectMetadata = projectState.metadata();
        try {
            ProjectMetadata updatedMetadata;
            boolean changed = false;
            HashSet<Index> indicesToDelete = new HashSet<Index>();
            for (AliasAction action : actions) {
                if (!action.removeIndex()) continue;
                IndexMetadata index = currentProjectMetadata.indices().get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                MetadataIndexAliasesService.validateAliasTargetIsNotDSBackingIndex(currentProjectMetadata, action);
                indicesToDelete.add(index.getIndex());
                changed = true;
            }
            if (changed) {
                currentState = MetadataDeleteIndexService.deleteIndices(projectState, indicesToDelete, this.clusterService.getSettings());
                currentProjectMetadata = currentState.metadata().getProject(projectId);
            }
            ProjectMetadata.Builder metadata = ProjectMetadata.builder(currentProjectMetadata);
            HashSet<String> maybeModifiedIndices = new HashSet<String>();
            for (AliasAction action : actions) {
                if (action.removeIndex()) continue;
                Function<String, String> lookup = name -> {
                    IndexMetadata imd = metadata.get((String)name);
                    if (imd != null) {
                        return imd.getIndex().getName();
                    }
                    DataStream dataStream = metadata.dataStream((String)name);
                    if (dataStream != null) {
                        return dataStream.getName();
                    }
                    return null;
                };
                DataStream dataStream = metadata.dataStream(action.getIndex());
                if (dataStream != null) {
                    AliasAction.NewAliasValidator newAliasValidator = (alias, indexRouting, searchRouting, filter, writeIndex) -> {
                        AliasValidator.validateAlias(alias, action.getIndex(), indexRouting, lookup);
                        if (Strings.hasLength(filter)) {
                            for (Index index : dataStream.getIndices()) {
                                IndexMetadata imd = metadata.get(index.getName());
                                if (imd == null) {
                                    throw new IndexNotFoundException(action.getIndex());
                                }
                                IndexSettings.MODE.get(imd.getSettings()).validateAlias(indexRouting, searchRouting);
                                this.validateFilter(indicesToClose, indices, action, imd, alias, filter);
                            }
                        }
                    };
                    if (!action.apply(newAliasValidator, metadata, null)) continue;
                    changed = true;
                    continue;
                }
                IndexMetadata index = metadata.get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                MetadataIndexAliasesService.validateAliasTargetIsNotDSBackingIndex(currentProjectMetadata, action);
                AliasAction.NewAliasValidator newAliasValidator = (alias, indexRouting, searchRouting, filter, writeIndex) -> {
                    AliasValidator.validateAlias(alias, action.getIndex(), indexRouting, lookup);
                    IndexSettings.MODE.get(index.getSettings()).validateAlias(indexRouting, searchRouting);
                    if (Strings.hasLength(filter)) {
                        this.validateFilter(indicesToClose, indices, action, index, alias, filter);
                    }
                };
                if (!action.apply(newAliasValidator, metadata, index)) continue;
                changed = true;
                maybeModifiedIndices.add(index.getIndex().getName());
            }
            for (String maybeModifiedIndex : maybeModifiedIndices) {
                IndexMetadata currentIndexMetadata = currentProjectMetadata.index(maybeModifiedIndex);
                IndexMetadata newIndexMetadata = metadata.get(maybeModifiedIndex);
                if (currentIndexMetadata.getAliases().equals(newIndexMetadata.getAliases())) continue;
                assert (currentIndexMetadata.getAliasesVersion() == newIndexMetadata.getAliasesVersion());
                metadata.put(new IndexMetadata.Builder(newIndexMetadata).aliasesVersion(1L + currentIndexMetadata.getAliasesVersion()));
            }
            if (changed && !(updatedMetadata = metadata.build()).equalsAliases(currentProjectMetadata)) {
                ClusterState clusterState = ClusterState.builder(currentState).putProjectMetadata(updatedMetadata).build();
                return clusterState;
            }
            ClusterState clusterState = currentState;
            return clusterState;
        }
        finally {
            for (Index index : indicesToClose) {
                this.indicesService.removeIndex(index, IndexRemovalReason.NO_LONGER_ASSIGNED, "created for alias processing", CloseUtils.NO_SHARDS_CREATED_EXECUTOR, ActionListener.noop());
            }
        }
    }

    ClusterStateTaskExecutor<ApplyAliasesTask> getExecutor() {
        return this.executor;
    }

    private void validateFilter(List<Index> indicesToClose, Map<String, IndexService> indices, AliasAction action, IndexMetadata index, String alias, String filter) {
        IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = indices.get(index.getIndex().getName());
        if (indexService == null) {
            indexService = this.indicesService.indexService(index.getIndex());
            if (indexService == null) {
                try {
                    indexService = this.indicesService.createIndex(index, Collections.emptyList(), false);
                    indicesToClose.add(index.getIndex());
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Failed to create temporary index for parsing the alias", (Throwable)e, new Object[0]);
                }
                ((IndexService)indexService).mapperService().merge(index, MapperService.MergeReason.MAPPING_RECOVERY);
            }
            indices.put(action.getIndex(), (IndexService)indexService);
        }
        AliasValidator.validateAliasFilter(alias, filter, ((IndexService)indexService).newSearchExecutionContext(0, 0, null, System::currentTimeMillis, null, Collections.emptyMap()), this.xContentRegistry);
    }

    private static void validateAliasTargetIsNotDSBackingIndex(ProjectMetadata projectMetadata, AliasAction action) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)projectMetadata.getIndicesLookup().get(action.getIndex());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + action.getIndex() + "] was not found";
        if (indexAbstraction.getParentDataStream() != null) {
            throw new IllegalArgumentException("The provided index [" + action.getIndex() + "] is a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data stream backing indices don't support alias operations.");
        }
    }

    record ApplyAliasesTask(IndicesAliasesClusterStateUpdateRequest request, ActionListener<IndicesAliasesResponse> listener) implements ClusterStateTaskListener,
    ClusterStateAckListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return true;
        }

        @Override
        public void onAllNodesAcked() {
            this.listener.onResponse(IndicesAliasesResponse.build(this.request.actionResults()));
        }

        @Override
        public void onAckFailure(Exception e) {
            this.listener.onResponse(IndicesAliasesResponse.NOT_ACKNOWLEDGED);
        }

        @Override
        public void onAckTimeout() {
            this.listener.onResponse(IndicesAliasesResponse.NOT_ACKNOWLEDGED);
        }

        @Override
        public TimeValue ackTimeout() {
            return this.request.ackTimeout();
        }
    }
}

