/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TermOverridingStreamOutput;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;

class TermOverridingMasterNodeRequest
extends AbstractTransportRequest {
    private static final Logger logger = LogManager.getLogger(TermOverridingMasterNodeRequest.class);
    final MasterNodeRequest<?> request;
    final long newMasterTerm;

    TermOverridingMasterNodeRequest(MasterNodeRequest<?> request, long newMasterTerm) {
        assert (request.masterTerm() <= newMasterTerm);
        this.request = request;
        this.newMasterTerm = newMasterTerm;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return (Task)TermOverridingMasterNodeRequest.unsupported();
    }

    @Override
    public String getDescription() {
        return this.request.getDescription();
    }

    @Override
    public void remoteAddress(InetSocketAddress remoteAddress) {
        TermOverridingMasterNodeRequest.unsupported();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)TermOverridingMasterNodeRequest.unsupported();
    }

    @Override
    public void incRef() {
        this.request.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.request.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.request.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.request.hasReferences();
    }

    @Override
    public void setParentTask(String parentTaskNode, long parentTaskId) {
        TermOverridingMasterNodeRequest.unsupported();
    }

    @Override
    public void setParentTask(TaskId taskId) {
        TermOverridingMasterNodeRequest.unsupported();
    }

    @Override
    public TaskId getParentTask() {
        return this.request.getParentTask();
    }

    @Override
    public void setRequestId(long requestId) {
        this.request.setRequestId(requestId);
    }

    @Override
    public long getRequestId() {
        return this.request.getRequestId();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        this.request.writeTo(new TermOverridingStreamOutput(out, this.newMasterTerm));
    }

    @Override
    public String toString() {
        return Strings.format("TermOverridingMasterNodeRequest[newMasterTerm=%d in %s]", this.newMasterTerm, this.request);
    }

    private static <T> T unsupported() {
        UnsupportedOperationException exception = new UnsupportedOperationException("TermOverridingMasterNodeRequest is only for outbound requests");
        logger.error("TermOverridingMasterNodeRequest is only for outbound requests", (Throwable)exception);
        assert (false) : exception;
        throw exception;
    }
}

