"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CurrentTabProvider", {
  enumerable: true,
  get: function () {
    return _hooks.CurrentTabProvider;
  }
});
Object.defineProperty(exports, "InternalStateProvider", {
  enumerable: true,
  get: function () {
    return _hooks.InternalStateProvider;
  }
});
Object.defineProperty(exports, "RuntimeStateProvider", {
  enumerable: true,
  get: function () {
    return _runtime_state.RuntimeStateProvider;
  }
});
Object.defineProperty(exports, "createInternalStateStore", {
  enumerable: true,
  get: function () {
    return _internal_state.createInternalStateStore;
  }
});
Object.defineProperty(exports, "createRuntimeStateManager", {
  enumerable: true,
  get: function () {
    return _runtime_state.createRuntimeStateManager;
  }
});
Object.defineProperty(exports, "createTabActionInjector", {
  enumerable: true,
  get: function () {
    return _utils.createTabActionInjector;
  }
});
Object.defineProperty(exports, "createTabItem", {
  enumerable: true,
  get: function () {
    return _utils.createTabItem;
  }
});
exports.internalStateActions = void 0;
Object.defineProperty(exports, "selectAllTabs", {
  enumerable: true,
  get: function () {
    return _selectors.selectAllTabs;
  }
});
Object.defineProperty(exports, "selectRecentlyClosedTabs", {
  enumerable: true,
  get: function () {
    return _selectors.selectRecentlyClosedTabs;
  }
});
Object.defineProperty(exports, "selectTab", {
  enumerable: true,
  get: function () {
    return _selectors.selectTab;
  }
});
Object.defineProperty(exports, "selectTabRuntimeState", {
  enumerable: true,
  get: function () {
    return _runtime_state.selectTabRuntimeState;
  }
});
Object.defineProperty(exports, "useAdHocDataViews", {
  enumerable: true,
  get: function () {
    return _runtime_state.useAdHocDataViews;
  }
});
Object.defineProperty(exports, "useCurrentChartPortalNode", {
  enumerable: true,
  get: function () {
    return _hooks.useCurrentChartPortalNode;
  }
});
Object.defineProperty(exports, "useCurrentDataView", {
  enumerable: true,
  get: function () {
    return _runtime_state.useCurrentDataView;
  }
});
Object.defineProperty(exports, "useCurrentTabAction", {
  enumerable: true,
  get: function () {
    return _hooks.useCurrentTabAction;
  }
});
Object.defineProperty(exports, "useCurrentTabRuntimeState", {
  enumerable: true,
  get: function () {
    return _runtime_state.useCurrentTabRuntimeState;
  }
});
Object.defineProperty(exports, "useCurrentTabSelector", {
  enumerable: true,
  get: function () {
    return _hooks.useCurrentTabSelector;
  }
});
Object.defineProperty(exports, "useDataViewsForPicker", {
  enumerable: true,
  get: function () {
    return _hooks.useDataViewsForPicker;
  }
});
Object.defineProperty(exports, "useInternalStateDispatch", {
  enumerable: true,
  get: function () {
    return _hooks.useInternalStateDispatch;
  }
});
Object.defineProperty(exports, "useInternalStateSelector", {
  enumerable: true,
  get: function () {
    return _hooks.useInternalStateSelector;
  }
});
Object.defineProperty(exports, "useRuntimeState", {
  enumerable: true,
  get: function () {
    return _runtime_state.useRuntimeState;
  }
});
var _lodash = require("lodash");
var _internal_state = require("./internal_state");
var _actions = require("./actions");
var _hooks = require("./hooks");
var _selectors = require("./selectors");
var _runtime_state = require("./runtime_state");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const internalStateActions = exports.internalStateActions = {
  ...(0, _lodash.omit)(_internal_state.internalStateSlice.actions, 'setTabs', 'setDataViewId', 'setDefaultProfileAdHocDataViewIds'),
  loadDataViewList: _actions.loadDataViewList,
  setTabs: _actions.setTabs,
  updateTabs: _actions.updateTabs,
  disconnectTab: _actions.disconnectTab,
  setDataView: _actions.setDataView,
  setAdHocDataViews: _actions.setAdHocDataViews,
  setDefaultProfileAdHocDataViews: _actions.setDefaultProfileAdHocDataViews,
  appendAdHocDataViews: _actions.appendAdHocDataViews,
  replaceAdHocDataViewWithId: _actions.replaceAdHocDataViewWithId,
  initializeSession: _actions.initializeSession,
  updateTabAppStateAndGlobalState: _actions.updateTabAppStateAndGlobalState,
  restoreTab: _actions.restoreTab,
  clearAllTabs: _actions.clearAllTabs,
  initializeTabs: _actions.initializeTabs
};