"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Filters;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_dataset_quality_filters = require("../../../hooks/use_dataset_quality_filters");
var _use_quick_time_ranges = require("../../../utils/use_quick_time_ranges");
var _filter_bar = require("./filter_bar");
var _integrations_selector = require("./integrations_selector");
var _namespaces_selector = require("./namespaces_selector");
var _qualities_selector = require("./qualities_selector");
var _selector = require("./selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const typesLabel = _i18n.i18n.translate('xpack.datasetQuality.types.label', {
  defaultMessage: 'Types'
});
const typesSearchPlaceholder = _i18n.i18n.translate('xpack.datasetQuality.selector.types.search.placeholder', {
  defaultMessage: 'Filter types'
});
const typesNoneMatching = _i18n.i18n.translate('xpack.datasetQuality.selector.types.noneMatching', {
  defaultMessage: 'No types found'
});
const typesNoneAvailable = _i18n.i18n.translate('xpack.datasetQuality.selector.types.noneAvailable', {
  defaultMessage: 'No types available'
});

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Filters() {
  const {
    timeRange,
    onTimeChange,
    onRefresh,
    onRefreshChange,
    isLoading,
    integrations,
    namespaces,
    qualities,
    types,
    onIntegrationsChange,
    onNamespacesChange,
    onQualitiesChange,
    onTypesChange,
    selectedQuery,
    onQueryChange,
    isDatasetQualityAllSignalsAvailable
  } = (0, _use_dataset_quality_filters.useDatasetQualityFilters)();
  const commonlyUsedRanges = (0, _use_quick_time_ranges.useQuickTimeRanges)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "datasetQualityFiltersContainer",
    gutterSize: "s",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
    query: selectedQuery,
    onQueryChange: onQueryChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_integrations_selector.IntegrationsSelector, {
    isLoading: isLoading,
    integrations: integrations,
    onIntegrationsChange: onIntegrationsChange
  }), isDatasetQualityAllSignalsAvailable && types.length > 1 && /*#__PURE__*/_react.default.createElement(_selector.Selector, {
    dataTestSubj: "datasetQualityFilterTypeSelectable",
    label: typesLabel,
    searchPlaceholder: typesSearchPlaceholder,
    noneMatchingMessage: typesNoneMatching,
    noneAvailableMessage: typesNoneAvailable,
    options: types,
    onOptionsChange: onTypesChange
  }), /*#__PURE__*/_react.default.createElement(_namespaces_selector.NamespacesSelector, {
    isLoading: isLoading,
    namespaces: namespaces,
    onNamespacesChange: onNamespacesChange
  }), /*#__PURE__*/_react.default.createElement(_qualities_selector.QualitiesSelector, {
    isLoading: isLoading,
    qualities: qualities,
    onQualitiesChange: onQualitiesChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: timeRange.from,
    end: timeRange.to,
    onTimeChange: onTimeChange,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    commonlyUsedRanges: commonlyUsedRanges,
    showUpdateButton: true,
    isPaused: timeRange.refresh.pause,
    refreshInterval: timeRange.refresh.value
  })));
}
module.exports = exports.default;