"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSuffix = exports.validatePrefix = exports.validateName = exports.validateLeaderIndexPatterns = exports.validateLeaderIndexPattern = exports.validateAutoFollowPattern = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  indexNameBeginsWithPeriod,
  findIllegalCharactersInIndexName,
  indexNameContainsSpaces
} = _shared_imports.indices;
const validateName = (name = '') => {
  let errorMsg = null;
  if (!name || !name.trim()) {
    errorMsg = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.nameValidation.errorEmptyName', {
      defaultMessage: 'Name is required.'
    });
  } else {
    if (name.includes(' ')) {
      errorMsg = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.nameValidation.errorSpace', {
        defaultMessage: 'Spaces are not allowed in the name.'
      });
    }
    if (name[0] === '_') {
      errorMsg = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.nameValidation.errorUnderscore', {
        defaultMessage: `Name can't begin with an underscore.`
      });
    }
    if (name.includes(',')) {
      errorMsg = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.nameValidation.errorComma', {
        defaultMessage: 'Commas are not allowed in the name.'
      });
    }
  }
  return errorMsg;
};
exports.validateName = validateName;
const validateLeaderIndexPattern = indexPattern => {
  if (indexPattern) {
    const errors = _public.indexPatterns.validate(indexPattern);
    if (errors[_public.indexPatterns.ILLEGAL_CHARACTERS_KEY]) {
      return {
        message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPattern.leaderIndexPatternValidation.illegalCharacters",
          defaultMessage: "Remove the {characterListLength, plural, one {character} other {characters}} {characterList} from the index pattern.",
          values: {
            characterList: /*#__PURE__*/_react.default.createElement("strong", null, errors[_public.indexPatterns.ILLEGAL_CHARACTERS_KEY].join(' ')),
            characterListLength: errors[_public.indexPatterns.ILLEGAL_CHARACTERS_KEY].length
          }
        })
      };
    }
    if (errors[_public.indexPatterns.CONTAINS_SPACES_KEY]) {
      return {
        message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPattern.leaderIndexPatternValidation.noEmptySpace",
          defaultMessage: "Spaces are not allowed in the index pattern."
        })
      };
    }
  }
  if (!indexPattern || !indexPattern.trim()) {
    return {
      message: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.leaderIndexPatternValidation.isEmpty', {
        defaultMessage: 'At least one leader index pattern is required.'
      })
    };
  }
  return null;
};
exports.validateLeaderIndexPattern = validateLeaderIndexPattern;
const validateLeaderIndexPatterns = indexPatterns => {
  // We only need to check if a value has been provided, because validation for this field
  // has already been executed as the user has entered input into it.
  if (!indexPatterns.length) {
    return {
      message: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPattern.leaderIndexPatternValidation.isEmpty', {
        defaultMessage: 'At least one leader index pattern is required.'
      })
    };
  }
  return null;
};
exports.validateLeaderIndexPatterns = validateLeaderIndexPatterns;
const validatePrefix = prefix => {
  // If it's empty, it is valid
  if (!prefix || !prefix.trim()) {
    return null;
  }

  // Prefix can't begin with a period, because that's reserved for system indices.
  if (indexNameBeginsWithPeriod(prefix)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPattern.prefixValidation.beginsWithPeriod",
      defaultMessage: "The prefix can't begin with a period."
    });
  }
  const illegalCharacters = findIllegalCharactersInIndexName(prefix);
  if (illegalCharacters.length) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPattern.prefixValidation.illegalCharacters",
      defaultMessage: "Remove the {characterListLength, plural, one {character} other {characters}} {characterList} from the prefix.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", null, illegalCharacters.join(' ')),
        characterListLength: illegalCharacters.length
      }
    });
  }
  if (indexNameContainsSpaces(prefix)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPattern.prefixValidation.noEmptySpace",
      defaultMessage: "Spaces are not allowed in the prefix."
    });
  }
  return null;
};
exports.validatePrefix = validatePrefix;
const validateSuffix = suffix => {
  // If it's empty, it is valid
  if (!suffix || !suffix.trim()) {
    return null;
  }
  const illegalCharacters = findIllegalCharactersInIndexName(suffix);
  if (illegalCharacters.length) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPattern.suffixValidation.illegalCharacters",
      defaultMessage: "Remove the {characterListLength, plural, one {character} other {characters}} {characterList} from the suffix.",
      values: {
        characterList: /*#__PURE__*/_react.default.createElement("strong", null, illegalCharacters.join(' ')),
        characterListLength: illegalCharacters.length
      }
    });
  }
  if (indexNameContainsSpaces(suffix)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPattern.suffixValidation.noEmptySpace",
      defaultMessage: "Spaces are not allowed in the suffix."
    });
  }
  return null;
};
exports.validateSuffix = validateSuffix;
const validateAutoFollowPattern = (autoFollowPattern = {}) => {
  const errors = {};
  let error = null;
  let fieldValue;
  Object.keys(autoFollowPattern).forEach(fieldName => {
    fieldValue = autoFollowPattern[fieldName];
    error = null;
    switch (fieldName) {
      case 'name':
        error = validateName(fieldValue);
        break;
      case 'leaderIndexPatterns':
        error = validateLeaderIndexPatterns(fieldValue);
        break;
      case 'followIndexPatternPrefix':
        error = validatePrefix(fieldValue);
        break;
      case 'followIndexPatternSuffix':
        error = validateSuffix(fieldValue);
        break;
    }
    errors[fieldName] = error;
  });
  return errors;
};
exports.validateAutoFollowPattern = validateAutoFollowPattern;