"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editorStateComparators = exports.defaultEditorState = void 0;
exports.initializeEditorStateManager = initializeEditorStateManager;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultEditorState = exports.defaultEditorState = {
  autoApplySelections: _common.DEFAULT_AUTO_APPLY_SELECTIONS,
  chainingSystem: _common.DEFAULT_CONTROL_CHAINING,
  ignoreParentSettings: _common.DEFAULT_IGNORE_PARENT_SETTINGS,
  labelPosition: _common.DEFAULT_CONTROL_LABEL_POSITION
};
const editorStateComparators = exports.editorStateComparators = {
  autoApplySelections: 'referenceEquality',
  chainingSystem: 'referenceEquality',
  ignoreParentSettings: 'deepEquality',
  labelPosition: 'referenceEquality'
};
function initializeEditorStateManager(initialState) {
  return (0, _presentationPublishing.initializeStateManager)(initialState, defaultEditorState);
}