"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wildcardTemplate = exports.spanWithinTemplate = exports.spanTermTemplate = exports.spanOrTemplate = exports.spanNotTemplate = exports.spanNearTemplate = exports.spanFirstTemplate = exports.spanContainingTemplate = exports.regexpTemplate = exports.rangeTemplate = exports.prefixTemplate = exports.fuzzyTemplate = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const regexpTemplate = exports.regexpTemplate = {
  FIELD: 'REGEXP'
};
const fuzzyTemplate = exports.fuzzyTemplate = {
  FIELD: {}
};
const prefixTemplate = exports.prefixTemplate = {
  FIELD: {
    value: ''
  }
};
const rangeTemplate = exports.rangeTemplate = {
  FIELD: {
    gte: 10,
    lte: 20
  }
};
const spanFirstTemplate = exports.spanFirstTemplate = {
  match: {
    span_term: {
      FIELD: 'VALUE'
    }
  },
  end: 3
};
const spanNearTemplate = exports.spanNearTemplate = {
  clauses: [{
    span_term: {
      FIELD: {
        value: 'VALUE'
      }
    }
  }],
  slop: 12,
  in_order: false
};
const spanTermTemplate = exports.spanTermTemplate = {
  FIELD: {
    value: 'VALUE'
  }
};
const spanNotTemplate = exports.spanNotTemplate = {
  include: {
    span_term: {
      FIELD: {
        value: 'VALUE'
      }
    }
  },
  exclude: {
    span_term: {
      FIELD: {
        value: 'VALUE'
      }
    }
  }
};
const spanOrTemplate = exports.spanOrTemplate = {
  clauses: [{
    span_term: {
      FIELD: {
        value: 'VALUE'
      }
    }
  }]
};
const spanContainingTemplate = exports.spanContainingTemplate = {
  little: {
    span_term: {
      FIELD: {
        value: 'VALUE'
      }
    }
  },
  big: {
    span_near: {
      clauses: [{
        span_term: {
          FIELD: {
            value: 'VALUE'
          }
        }
      }, {
        span_term: {
          FIELD: {
            value: 'VALUE'
          }
        }
      }],
      slop: 5,
      in_order: false
    }
  }
};
const spanWithinTemplate = exports.spanWithinTemplate = {
  little: {
    span_term: {
      FIELD: {
        value: 'VALUE'
      }
    }
  },
  big: {
    span_near: {
      clauses: [{
        span_term: {
          FIELD: {
            value: 'VALUE'
          }
        }
      }, {
        span_term: {
          FIELD: {
            value: 'VALUE'
          }
        }
      }],
      slop: 5,
      in_order: false
    }
  }
};
const wildcardTemplate = exports.wildcardTemplate = {
  FIELD: {
    value: 'VALUE'
  }
};