"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsUserActionBuilder = void 0;
var _constants = require("../../../../common/constants");
var _domain = require("../../../../common/types/domain");
var _abstract_builder = require("../abstract_builder");
var _audit_logger_utils = require("./audit_logger_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TagsUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    var _args$action, _args$action2;
    const action = (_args$action = args.action) !== null && _args$action !== void 0 ? _args$action : _domain.UserActionActions.add;
    const parameters = this.buildCommonUserAction({
      ...args,
      action: (_args$action2 = args.action) !== null && _args$action2 !== void 0 ? _args$action2 : _domain.UserActionActions.add,
      valueKey: 'tags',
      value: args.payload.tags,
      type: _domain.UserActionTypes.tags
    });
    const verb = (0, _audit_logger_utils.getPastTenseVerb)(action);
    const preposition = getPreposition(action);
    const getMessage = id => `User ${verb} tags ${preposition} case id: ${args.caseId} - user action id: ${id}`;
    const eventDetails = {
      getMessage,
      action,
      descriptiveAction: `case_user_action_${action}_case_tags`,
      savedObjectId: args.caseId,
      savedObjectType: _constants.CASE_SAVED_OBJECT
    };
    return {
      parameters,
      eventDetails
    };
  }
}
exports.TagsUserActionBuilder = TagsUserActionBuilder;
const getPreposition = action => {
  switch (action) {
    case _domain.UserActionActions.add:
      return 'to';
    case _domain.UserActionActions.delete:
      return 'in';
    default:
      return 'for';
  }
};